/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AuthMode;
import software.amazon.awssdk.services.sagemaker.model.DomainStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SubnetsCopier;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeDomainResponse> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainArn)).setter(DescribeDomainResponse.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainId)).setter(DescribeDomainResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainName)).setter(DescribeDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::homeEfsFileSystemId)).setter(DescribeDomainResponse.setter(Builder::homeEfsFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemId").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::singleSignOnManagedApplicationInstanceId)).setter(DescribeDomainResponse.setter(Builder::singleSignOnManagedApplicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnManagedApplicationInstanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::statusAsString)).setter(DescribeDomainResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDomainResponse.getter(DescribeDomainResponse::creationTime)).setter(DescribeDomainResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDomainResponse.getter(DescribeDomainResponse::lastModifiedTime)).setter(DescribeDomainResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::failureReason)).setter(DescribeDomainResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::authModeAsString)).setter(DescribeDomainResponse.setter(Builder::authMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()}).build();
    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeDomainResponse.getter(DescribeDomainResponse::defaultUserSettings)).setter(DescribeDomainResponse.setter(Builder::defaultUserSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::homeEfsFileSystemKmsKeyId)).setter(DescribeDomainResponse.setter(Builder::homeEfsFileSystemKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDomainResponse.getter(DescribeDomainResponse::subnetIds)).setter(DescribeDomainResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::url)).setter(DescribeDomainResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainResponse.getter(DescribeDomainResponse::vpcId)).setter(DescribeDomainResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, HOME_EFS_FILE_SYSTEM_ID_FIELD, SINGLE_SIGN_ON_MANAGED_APPLICATION_INSTANCE_ID_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD, HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD, SUBNET_IDS_FIELD, URL_FIELD, VPC_ID_FIELD));
    private final String domainArn;
    private final String domainId;
    private final String domainName;
    private final String homeEfsFileSystemId;
    private final String singleSignOnManagedApplicationInstanceId;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final String authMode;
    private final UserSettings defaultUserSettings;
    private final String homeEfsFileSystemKmsKeyId;
    private final List<String> subnetIds;
    private final String url;
    private final String vpcId;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.homeEfsFileSystemId = builder.homeEfsFileSystemId;
        this.singleSignOnManagedApplicationInstanceId = builder.singleSignOnManagedApplicationInstanceId;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
        this.subnetIds = builder.subnetIds;
        this.url = builder.url;
        this.vpcId = builder.vpcId;
    }

    public String domainArn() {
        return this.domainArn;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String homeEfsFileSystemId() {
        return this.homeEfsFileSystemId;
    }

    public String singleSignOnManagedApplicationInstanceId() {
        return this.singleSignOnManagedApplicationInstanceId;
    }

    public DomainStatus status() {
        return DomainStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public AuthMode authMode() {
        return AuthMode.fromValue(this.authMode);
    }

    public String authModeAsString() {
        return this.authMode;
    }

    public UserSettings defaultUserSettings() {
        return this.defaultUserSettings;
    }

    public String homeEfsFileSystemKmsKeyId() {
        return this.homeEfsFileSystemKmsKeyId;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String url() {
        return this.url;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnManagedApplicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse)((Object)obj);
        return Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.homeEfsFileSystemId(), other.homeEfsFileSystemId()) && Objects.equals(this.singleSignOnManagedApplicationInstanceId(), other.singleSignOnManagedApplicationInstanceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.authModeAsString(), other.authModeAsString()) && Objects.equals(this.defaultUserSettings(), other.defaultUserSettings()) && Objects.equals(this.homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainResponse").add("DomainArn", (Object)this.domainArn()).add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("HomeEfsFileSystemId", (Object)this.homeEfsFileSystemId()).add("SingleSignOnManagedApplicationInstanceId", (Object)this.singleSignOnManagedApplicationInstanceId()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("AuthMode", (Object)this.authModeAsString()).add("DefaultUserSettings", (Object)this.defaultUserSettings()).add("HomeEfsFileSystemKmsKeyId", (Object)this.homeEfsFileSystemKmsKeyId()).add("SubnetIds", this.subnetIds()).add("Url", (Object)this.url()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "HomeEfsFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemId()));
            }
            case "SingleSignOnManagedApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnManagedApplicationInstanceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "AuthMode": {
                return Optional.ofNullable(clazz.cast(this.authModeAsString()));
            }
            case "DefaultUserSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultUserSettings()));
            }
            case "HomeEfsFileSystemKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemKmsKeyId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String domainArn;
        private String domainId;
        private String domainName;
        private String homeEfsFileSystemId;
        private String singleSignOnManagedApplicationInstanceId;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private String authMode;
        private UserSettings defaultUserSettings;
        private String homeEfsFileSystemKmsKeyId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String url;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            this.domainArn(model.domainArn);
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.homeEfsFileSystemId(model.homeEfsFileSystemId);
            this.singleSignOnManagedApplicationInstanceId(model.singleSignOnManagedApplicationInstanceId);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.authMode(model.authMode);
            this.defaultUserSettings(model.defaultUserSettings);
            this.homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
            this.subnetIds(model.subnetIds);
            this.url(model.url);
            this.vpcId(model.vpcId);
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getHomeEfsFileSystemId() {
            return this.homeEfsFileSystemId;
        }

        @Override
        public final Builder homeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
            return this;
        }

        public final void setHomeEfsFileSystemId(String homeEfsFileSystemId) {
            this.homeEfsFileSystemId = homeEfsFileSystemId;
        }

        public final String getSingleSignOnManagedApplicationInstanceId() {
            return this.singleSignOnManagedApplicationInstanceId;
        }

        @Override
        public final Builder singleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
            return this;
        }

        public final void setSingleSignOnManagedApplicationInstanceId(String singleSignOnManagedApplicationInstanceId) {
            this.singleSignOnManagedApplicationInstanceId = singleSignOnManagedApplicationInstanceId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getAuthMode() {
            return this.authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return this.defaultUserSettings != null ? this.defaultUserSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        public final String getHomeEfsFileSystemKmsKeyId() {
            return this.homeEfsFileSystemKmsKeyId;
        }

        @Override
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainResponse> {
        public Builder domainArn(String var1);

        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder homeEfsFileSystemId(String var1);

        public Builder singleSignOnManagedApplicationInstanceId(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder authMode(String var1);

        public Builder authMode(AuthMode var1);

        public Builder defaultUserSettings(UserSettings var1);

        default public Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return this.defaultUserSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(defaultUserSettings)).build());
        }

        public Builder homeEfsFileSystemKmsKeyId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder url(String var1);

        public Builder vpcId(String var1);
    }
}

