/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SourceIpConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workforce
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workforce> {
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workforce.getter(Workforce::workforceName)).setter(Workforce.setter(Builder::workforceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()}).build();
    private static final SdkField<String> WORKFORCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workforce.getter(Workforce::workforceArn)).setter(Workforce.setter(Builder::workforceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Workforce.getter(Workforce::lastUpdatedDate)).setter(Workforce.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Workforce.getter(Workforce::sourceIpConfig)).setter(Workforce.setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_NAME_FIELD, WORKFORCE_ARN_FIELD, LAST_UPDATED_DATE_FIELD, SOURCE_IP_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workforceName;
    private final String workforceArn;
    private final Instant lastUpdatedDate;
    private final SourceIpConfig sourceIpConfig;

    private Workforce(BuilderImpl builder) {
        this.workforceName = builder.workforceName;
        this.workforceArn = builder.workforceArn;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.sourceIpConfig = builder.sourceIpConfig;
    }

    public String workforceName() {
        return this.workforceName;
    }

    public String workforceArn() {
        return this.workforceArn;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public SourceIpConfig sourceIpConfig() {
        return this.sourceIpConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workforce)) {
            return false;
        }
        Workforce other = (Workforce)obj;
        return Objects.equals(this.workforceName(), other.workforceName()) && Objects.equals(this.workforceArn(), other.workforceArn()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.sourceIpConfig(), other.sourceIpConfig());
    }

    public String toString() {
        return ToString.builder((String)"Workforce").add("WorkforceName", (Object)this.workforceName()).add("WorkforceArn", (Object)this.workforceArn()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("SourceIpConfig", (Object)this.sourceIpConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkforceName": {
                return Optional.ofNullable(clazz.cast(this.workforceName()));
            }
            case "WorkforceArn": {
                return Optional.ofNullable(clazz.cast(this.workforceArn()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "SourceIpConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceIpConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workforce, T> g) {
        return obj -> g.apply((Workforce)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workforceName;
        private String workforceArn;
        private Instant lastUpdatedDate;
        private SourceIpConfig sourceIpConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Workforce model) {
            this.workforceName(model.workforceName);
            this.workforceArn(model.workforceArn);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.sourceIpConfig(model.sourceIpConfig);
        }

        public final String getWorkforceName() {
            return this.workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        public final String getWorkforceArn() {
            return this.workforceArn;
        }

        @Override
        public final Builder workforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
            return this;
        }

        public final void setWorkforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return this.sourceIpConfig != null ? this.sourceIpConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        public Workforce build() {
            return new Workforce(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workforce> {
        public Builder workforceName(String var1);

        public Builder workforceArn(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder sourceIpConfig(SourceIpConfig var1);

        default public Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return this.sourceIpConfig((SourceIpConfig)((SourceIpConfig.Builder)SourceIpConfig.builder().applyMutation(sourceIpConfig)).build());
        }
    }
}

