/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageSummary> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageName)).setter(ModelPackageSummary.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageArn)).setter(ModelPackageSummary.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageDescription)).setter(ModelPackageSummary.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ModelPackageSummary.getter(ModelPackageSummary::creationTime)).setter(ModelPackageSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageStatusAsString)).setter(ModelPackageSummary.setter(Builder::modelPackageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, MODEL_PACKAGE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelPackageName;
    private final String modelPackageArn;
    private final String modelPackageDescription;
    private final Instant creationTime;
    private final String modelPackageStatus;

    private ModelPackageSummary(BuilderImpl builder) {
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.modelPackageStatus = builder.modelPackageStatus;
    }

    public String modelPackageName() {
        return this.modelPackageName;
    }

    public String modelPackageArn() {
        return this.modelPackageArn;
    }

    public String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(this.modelPackageStatus);
    }

    public String modelPackageStatusAsString() {
        return this.modelPackageStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageSummary)) {
            return false;
        }
        ModelPackageSummary other = (ModelPackageSummary)obj;
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelPackageStatusAsString(), other.modelPackageStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModelPackageSummary").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("CreationTime", (Object)this.creationTime()).add("ModelPackageStatus", (Object)this.modelPackageStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelPackageStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageSummary, T> g) {
        return obj -> g.apply((ModelPackageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageArn;
        private String modelPackageDescription;
        private Instant creationTime;
        private String modelPackageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageSummary model) {
            this.modelPackageName(model.modelPackageName);
            this.modelPackageArn(model.modelPackageArn);
            this.modelPackageDescription(model.modelPackageDescription);
            this.creationTime(model.creationTime);
            this.modelPackageStatus(model.modelPackageStatus);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelPackageStatus() {
            return this.modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        public ModelPackageSummary build() {
            return new ModelPackageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageSummary> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageArn(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder modelPackageStatus(String var1);

        public Builder modelPackageStatus(ModelPackageStatus var1);
    }
}

