/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ProcessingInstanceType;
import software.amazon.awssdk.services.sagemaker.model.RuleParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DebugRuleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DebugRuleConfiguration> {
    private static final SdkField<String> RULE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::ruleConfigurationName)).setter(DebugRuleConfiguration.setter(Builder::ruleConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfigurationName").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::localPath)).setter(DebugRuleConfiguration.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::s3OutputPath)).setter(DebugRuleConfiguration.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<String> RULE_EVALUATOR_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::ruleEvaluatorImage)).setter(DebugRuleConfiguration.setter(Builder::ruleEvaluatorImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleEvaluatorImage").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::instanceTypeAsString)).setter(DebugRuleConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::volumeSizeInGB)).setter(DebugRuleConfiguration.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<Map<String, String>> RULE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DebugRuleConfiguration.getter(DebugRuleConfiguration::ruleParameters)).setter(DebugRuleConfiguration.setter(Builder::ruleParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_CONFIGURATION_NAME_FIELD, LOCAL_PATH_FIELD, S3_OUTPUT_PATH_FIELD, RULE_EVALUATOR_IMAGE_FIELD, INSTANCE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD, RULE_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleConfigurationName;
    private final String localPath;
    private final String s3OutputPath;
    private final String ruleEvaluatorImage;
    private final String instanceType;
    private final Integer volumeSizeInGB;
    private final Map<String, String> ruleParameters;

    private DebugRuleConfiguration(BuilderImpl builder) {
        this.ruleConfigurationName = builder.ruleConfigurationName;
        this.localPath = builder.localPath;
        this.s3OutputPath = builder.s3OutputPath;
        this.ruleEvaluatorImage = builder.ruleEvaluatorImage;
        this.instanceType = builder.instanceType;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.ruleParameters = builder.ruleParameters;
    }

    public String ruleConfigurationName() {
        return this.ruleConfigurationName;
    }

    public String localPath() {
        return this.localPath;
    }

    public String s3OutputPath() {
        return this.s3OutputPath;
    }

    public String ruleEvaluatorImage() {
        return this.ruleEvaluatorImage;
    }

    public ProcessingInstanceType instanceType() {
        return ProcessingInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public boolean hasRuleParameters() {
        return this.ruleParameters != null && !(this.ruleParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> ruleParameters() {
        return this.ruleParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleEvaluatorImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugRuleConfiguration)) {
            return false;
        }
        DebugRuleConfiguration other = (DebugRuleConfiguration)obj;
        return Objects.equals(this.ruleConfigurationName(), other.ruleConfigurationName()) && Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.ruleEvaluatorImage(), other.ruleEvaluatorImage()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.ruleParameters(), other.ruleParameters());
    }

    public String toString() {
        return ToString.builder((String)"DebugRuleConfiguration").add("RuleConfigurationName", (Object)this.ruleConfigurationName()).add("LocalPath", (Object)this.localPath()).add("S3OutputPath", (Object)this.s3OutputPath()).add("RuleEvaluatorImage", (Object)this.ruleEvaluatorImage()).add("InstanceType", (Object)this.instanceTypeAsString()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("RuleParameters", this.ruleParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.ruleConfigurationName()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "RuleEvaluatorImage": {
                return Optional.ofNullable(clazz.cast(this.ruleEvaluatorImage()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "RuleParameters": {
                return Optional.ofNullable(clazz.cast(this.ruleParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DebugRuleConfiguration, T> g) {
        return obj -> g.apply((DebugRuleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleConfigurationName;
        private String localPath;
        private String s3OutputPath;
        private String ruleEvaluatorImage;
        private String instanceType;
        private Integer volumeSizeInGB;
        private Map<String, String> ruleParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DebugRuleConfiguration model) {
            this.ruleConfigurationName(model.ruleConfigurationName);
            this.localPath(model.localPath);
            this.s3OutputPath(model.s3OutputPath);
            this.ruleEvaluatorImage(model.ruleEvaluatorImage);
            this.instanceType(model.instanceType);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.ruleParameters(model.ruleParameters);
        }

        public final String getRuleConfigurationName() {
            return this.ruleConfigurationName;
        }

        @Override
        public final Builder ruleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
            return this;
        }

        public final void setRuleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final String getRuleEvaluatorImage() {
            return this.ruleEvaluatorImage;
        }

        @Override
        public final Builder ruleEvaluatorImage(String ruleEvaluatorImage) {
            this.ruleEvaluatorImage = ruleEvaluatorImage;
            return this;
        }

        public final void setRuleEvaluatorImage(String ruleEvaluatorImage) {
            this.ruleEvaluatorImage = ruleEvaluatorImage;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProcessingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final Map<String, String> getRuleParameters() {
            return this.ruleParameters;
        }

        @Override
        public final Builder ruleParameters(Map<String, String> ruleParameters) {
            this.ruleParameters = RuleParametersCopier.copy(ruleParameters);
            return this;
        }

        public final void setRuleParameters(Map<String, String> ruleParameters) {
            this.ruleParameters = RuleParametersCopier.copy(ruleParameters);
        }

        public DebugRuleConfiguration build() {
            return new DebugRuleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DebugRuleConfiguration> {
        public Builder ruleConfigurationName(String var1);

        public Builder localPath(String var1);

        public Builder s3OutputPath(String var1);

        public Builder ruleEvaluatorImage(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ProcessingInstanceType var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder ruleParameters(Map<String, String> var1);
    }
}

