/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InputConfig;
import software.amazon.awssdk.services.sagemaker.model.OutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCompilationJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateCompilationJobRequest> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::compilationJobName)).setter(CreateCompilationJobRequest.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::roleArn)).setter(CreateCompilationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::inputConfig)).setter(CreateCompilationJobRequest.setter(Builder::inputConfig)).constructor(InputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::outputConfig)).setter(CreateCompilationJobRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::stoppingCondition)).setter(CreateCompilationJobRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, STOPPING_CONDITION_FIELD));
    private final String compilationJobName;
    private final String roleArn;
    private final InputConfig inputConfig;
    private final OutputConfig outputConfig;
    private final StoppingCondition stoppingCondition;

    private CreateCompilationJobRequest(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.stoppingCondition = builder.stoppingCondition;
    }

    public String compilationJobName() {
        return this.compilationJobName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public InputConfig inputConfig() {
        return this.inputConfig;
    }

    public OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCompilationJobRequest)) {
            return false;
        }
        CreateCompilationJobRequest other = (CreateCompilationJobRequest)((Object)obj);
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition());
    }

    public String toString() {
        return ToString.builder((String)"CreateCompilationJobRequest").add("CompilationJobName", (Object)this.compilationJobName()).add("RoleArn", (Object)this.roleArn()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCompilationJobRequest, T> g) {
        return obj -> g.apply((CreateCompilationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String roleArn;
        private InputConfig inputConfig;
        private OutputConfig outputConfig;
        private StoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCompilationJobRequest model) {
            super(model);
            this.compilationJobName(model.compilationJobName);
            this.roleArn(model.roleArn);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
            this.stoppingCondition(model.stoppingCondition);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final InputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCompilationJobRequest build() {
            return new CreateCompilationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCompilationJobRequest> {
        public Builder compilationJobName(String var1);

        public Builder roleArn(String var1);

        public Builder inputConfig(InputConfig var1);

        default public Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return this.inputConfig((InputConfig)((InputConfig.Builder)InputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

