/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingJobSummary> {
    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingJobSummary.getter(ProcessingJobSummary::processingJobName)).setter(ProcessingJobSummary.setter(Builder::processingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingJobSummary.getter(ProcessingJobSummary::processingJobArn)).setter(ProcessingJobSummary.setter(Builder::processingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProcessingJobSummary.getter(ProcessingJobSummary::creationTime)).setter(ProcessingJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> PROCESSING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProcessingJobSummary.getter(ProcessingJobSummary::processingEndTime)).setter(ProcessingJobSummary.setter(Builder::processingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProcessingJobSummary.getter(ProcessingJobSummary::lastModifiedTime)).setter(ProcessingJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingJobSummary.getter(ProcessingJobSummary::processingJobStatusAsString)).setter(ProcessingJobSummary.setter(Builder::processingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingJobSummary.getter(ProcessingJobSummary::failureReason)).setter(ProcessingJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> EXIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingJobSummary.getter(ProcessingJobSummary::exitMessage)).setter(ProcessingJobSummary.setter(Builder::exitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_JOB_NAME_FIELD, PROCESSING_JOB_ARN_FIELD, CREATION_TIME_FIELD, PROCESSING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, PROCESSING_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, EXIT_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String processingJobName;
    private final String processingJobArn;
    private final Instant creationTime;
    private final Instant processingEndTime;
    private final Instant lastModifiedTime;
    private final String processingJobStatus;
    private final String failureReason;
    private final String exitMessage;

    private ProcessingJobSummary(BuilderImpl builder) {
        this.processingJobName = builder.processingJobName;
        this.processingJobArn = builder.processingJobArn;
        this.creationTime = builder.creationTime;
        this.processingEndTime = builder.processingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.processingJobStatus = builder.processingJobStatus;
        this.failureReason = builder.failureReason;
        this.exitMessage = builder.exitMessage;
    }

    public String processingJobName() {
        return this.processingJobName;
    }

    public String processingJobArn() {
        return this.processingJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant processingEndTime() {
        return this.processingEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ProcessingJobStatus processingJobStatus() {
        return ProcessingJobStatus.fromValue(this.processingJobStatus);
    }

    public String processingJobStatusAsString() {
        return this.processingJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String exitMessage() {
        return this.exitMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingJobSummary)) {
            return false;
        }
        ProcessingJobSummary other = (ProcessingJobSummary)obj;
        return Objects.equals(this.processingJobName(), other.processingJobName()) && Objects.equals(this.processingJobArn(), other.processingJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.processingEndTime(), other.processingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.processingJobStatusAsString(), other.processingJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.exitMessage(), other.exitMessage());
    }

    public String toString() {
        return ToString.builder((String)"ProcessingJobSummary").add("ProcessingJobName", (Object)this.processingJobName()).add("ProcessingJobArn", (Object)this.processingJobArn()).add("CreationTime", (Object)this.creationTime()).add("ProcessingEndTime", (Object)this.processingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ProcessingJobStatus", (Object)this.processingJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("ExitMessage", (Object)this.exitMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessingJobName": {
                return Optional.ofNullable(clazz.cast(this.processingJobName()));
            }
            case "ProcessingJobArn": {
                return Optional.ofNullable(clazz.cast(this.processingJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ProcessingEndTime": {
                return Optional.ofNullable(clazz.cast(this.processingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "ProcessingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.processingJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ExitMessage": {
                return Optional.ofNullable(clazz.cast(this.exitMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingJobSummary, T> g) {
        return obj -> g.apply((ProcessingJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String processingJobName;
        private String processingJobArn;
        private Instant creationTime;
        private Instant processingEndTime;
        private Instant lastModifiedTime;
        private String processingJobStatus;
        private String failureReason;
        private String exitMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingJobSummary model) {
            this.processingJobName(model.processingJobName);
            this.processingJobArn(model.processingJobArn);
            this.creationTime(model.creationTime);
            this.processingEndTime(model.processingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.processingJobStatus(model.processingJobStatus);
            this.failureReason(model.failureReason);
            this.exitMessage(model.exitMessage);
        }

        public final String getProcessingJobName() {
            return this.processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        public final String getProcessingJobArn() {
            return this.processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getProcessingEndTime() {
            return this.processingEndTime;
        }

        @Override
        public final Builder processingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
            return this;
        }

        public final void setProcessingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getProcessingJobStatus() {
            return this.processingJobStatus;
        }

        @Override
        public final Builder processingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
            return this;
        }

        @Override
        public final Builder processingJobStatus(ProcessingJobStatus processingJobStatus) {
            this.processingJobStatus(processingJobStatus == null ? null : processingJobStatus.toString());
            return this;
        }

        public final void setProcessingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getExitMessage() {
            return this.exitMessage;
        }

        @Override
        public final Builder exitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
            return this;
        }

        public final void setExitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
        }

        public ProcessingJobSummary build() {
            return new ProcessingJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingJobSummary> {
        public Builder processingJobName(String var1);

        public Builder processingJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder processingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder processingJobStatus(String var1);

        public Builder processingJobStatus(ProcessingJobStatus var1);

        public Builder failureReason(String var1);

        public Builder exitMessage(String var1);
    }
}

