/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrialsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListTrialsRequest.Builder, ListTrialsRequest> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsRequest::experimentName)).setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsRequest::trialComponentName)).setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListTrialsRequest::createdAfter)).setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListTrialsRequest::createdBefore)).setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTrialsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD,
            TRIAL_COMPONENT_NAME_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String experimentName;

    private final String trialComponentName;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String sortBy;

    private final String sortOrder;

    private final Integer maxResults;

    private final String nextToken;

    private ListTrialsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentName = builder.experimentName;
        this.trialComponentName = builder.trialComponentName;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A filter that returns only trials that are part of the specified experiment.
     * </p>
     * 
     * @return A filter that returns only trials that are part of the specified experiment.
     */
    public String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * A filter that returns only trials that are associated with the specified trial component.
     * </p>
     * 
     * @return A filter that returns only trials that are associated with the specified trial component.
     */
    public String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * A filter that returns only trials created after the specified time.
     * </p>
     * 
     * @return A filter that returns only trials created after the specified time.
     */
    public Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * A filter that returns only trials created before the specified time.
     * </p>
     * 
     * @return A filter that returns only trials created before the specified time.
     */
    public Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrialsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see SortTrialsBy
     */
    public SortTrialsBy sortBy() {
        return SortTrialsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrialsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see SortTrialsBy
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of trials to return in the response. The default value is 10.
     * </p>
     * 
     * @return The maximum number of trials to return in the response. The default value is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous call to <code>ListTrials</code> didn't return the full set of trials, the call returns a token
     * for getting the next set of trials.
     * </p>
     * 
     * @return If the previous call to <code>ListTrials</code> didn't return the full set of trials, the call returns a
     *         token for getting the next set of trials.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialsRequest)) {
            return false;
        }
        ListTrialsRequest other = (ListTrialsRequest) obj;
        return Objects.equals(experimentName(), other.experimentName())
                && Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTrialsRequest").add("ExperimentName", experimentName())
                .add("TrialComponentName", trialComponentName()).add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialsRequest, T> g) {
        return obj -> g.apply((ListTrialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTrialsRequest> {
        /**
         * <p>
         * A filter that returns only trials that are part of the specified experiment.
         * </p>
         * 
         * @param experimentName
         *        A filter that returns only trials that are part of the specified experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * A filter that returns only trials that are associated with the specified trial component.
         * </p>
         * 
         * @param trialComponentName
         *        A filter that returns only trials that are associated with the specified trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * A filter that returns only trials created after the specified time.
         * </p>
         * 
         * @param createdAfter
         *        A filter that returns only trials created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * A filter that returns only trials created before the specified time.
         * </p>
         * 
         * @param createdBefore
         *        A filter that returns only trials created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see SortTrialsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrialsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see SortTrialsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrialsBy
         */
        Builder sortBy(SortTrialsBy sortBy);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum number of trials to return in the response. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of trials to return in the response. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous call to <code>ListTrials</code> didn't return the full set of trials, the call returns a
         * token for getting the next set of trials.
         * </p>
         * 
         * @param nextToken
         *        If the previous call to <code>ListTrials</code> didn't return the full set of trials, the call returns
         *        a token for getting the next set of trials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String experimentName;

        private String trialComponentName;

        private Instant createdAfter;

        private Instant createdBefore;

        private String sortBy;

        private String sortOrder;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialsRequest model) {
            super(model);
            experimentName(model.experimentName);
            trialComponentName(model.trialComponentName);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getExperimentName() {
            return experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortTrialsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrialsRequest build() {
            return new ListTrialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
