/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookInstancesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListNotebookInstancesResponse.Builder, ListNotebookInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NotebookInstanceSummary>> NOTEBOOK_INSTANCES_FIELD = SdkField
            .<List<NotebookInstanceSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListNotebookInstancesResponse::notebookInstances))
            .setter(setter(Builder::notebookInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTEBOOK_INSTANCES_FIELD));

    private final String nextToken;

    private final List<NotebookInstanceSummary> notebookInstances;

    private ListNotebookInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstances = builder.notebookInstances;
    }

    /**
     * <p>
     * If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker
     * returns this token. To retrieve the next set of notebook instances, use the token in the next request.
     * </p>
     * 
     * @return If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon
     *         SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next
     *         request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the NotebookInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNotebookInstances() {
        return notebookInstances != null && !(notebookInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotebookInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
     */
    public List<NotebookInstanceSummary> notebookInstances() {
        return notebookInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstancesResponse)) {
            return false;
        }
        ListNotebookInstancesResponse other = (ListNotebookInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(notebookInstances(), other.notebookInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNotebookInstancesResponse").add("NextToken", nextToken())
                .add("NotebookInstances", notebookInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NotebookInstances":
            return Optional.ofNullable(clazz.cast(notebookInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstancesResponse, T> g) {
        return obj -> g.apply((ListNotebookInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNotebookInstancesResponse> {
        /**
         * <p>
         * If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker
         * returns this token. To retrieve the next set of notebook instances, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon
         *        SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
         * </p>
         * 
         * @param notebookInstances
         *        An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstances(Collection<NotebookInstanceSummary> notebookInstances);

        /**
         * <p>
         * An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
         * </p>
         * 
         * @param notebookInstances
         *        An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstances(NotebookInstanceSummary... notebookInstances);

        /**
         * <p>
         * An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotebookInstanceSummary>.Builder} avoiding
         * the need to create one manually via {@link List<NotebookInstanceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotebookInstanceSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #notebookInstances(List<NotebookInstanceSummary>)}.
         * 
         * @param notebookInstances
         *        a consumer that will call methods on {@link List<NotebookInstanceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookInstances(List<NotebookInstanceSummary>)
         */
        Builder notebookInstances(Consumer<NotebookInstanceSummary.Builder>... notebookInstances);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotebookInstanceSummary> notebookInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstancesResponse model) {
            super(model);
            nextToken(model.nextToken);
            notebookInstances(model.notebookInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotebookInstanceSummary.Builder> getNotebookInstances() {
            return notebookInstances != null ? notebookInstances.stream().map(NotebookInstanceSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notebookInstances(Collection<NotebookInstanceSummary> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copy(notebookInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstances(NotebookInstanceSummary... notebookInstances) {
            notebookInstances(Arrays.asList(notebookInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstances(Consumer<NotebookInstanceSummary.Builder>... notebookInstances) {
            notebookInstances(Stream.of(notebookInstances).map(c -> NotebookInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNotebookInstances(Collection<NotebookInstanceSummary.BuilderImpl> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copyFromBuilder(notebookInstances);
        }

        @Override
        public ListNotebookInstancesResponse build() {
            return new ListNotebookInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
