/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value.
 * Resources that match the statement are returned in the results from the <a>Search</a> API.
 * </p>
 * <p>
 * If you specify a <code>Value</code>, but not an <code>Operator</code>, Amazon SageMaker uses the equals operator.
 * </p>
 * <p>
 * In search, there are several property types:
 * </p>
 * <dl>
 * <dt>Metrics</dt>
 * <dd>
 * <p>
 * To define a metric filter, enter a value using the form <code>"Metrics.&lt;name&gt;"</code>, where
 * <code>&lt;name&gt;</code> is a metric name. For example, the following filter searches for training jobs with an
 * <code>"accuracy"</code> metric greater than <code>"0.9"</code>:
 * </p>
 * <p>
 * <code>{</code>
 * </p>
 * <p>
 * <code>"Name": "Metrics.accuracy",</code>
 * </p>
 * <p>
 * <code>"Operator": "GreaterThan",</code>
 * </p>
 * <p>
 * <code>"Value": "0.9"</code>
 * </p>
 * <p>
 * <code>}</code>
 * </p>
 * </dd>
 * <dt>HyperParameters</dt>
 * <dd>
 * <p>
 * To define a hyperparameter filter, enter a value with the form <code>"HyperParameters.&lt;name&gt;"</code>. Decimal
 * hyperparameter values are treated as a decimal in a comparison if the specified <code>Value</code> is also a decimal
 * value. If the specified <code>Value</code> is an integer, the decimal hyperparameter values are treated as integers.
 * For example, the following filter is satisfied by training jobs with a <code>"learning_rate"</code> hyperparameter
 * that is less than <code>"0.5"</code>:
 * </p>
 * <p>
 * <code> {</code>
 * </p>
 * <p>
 * <code> "Name": "HyperParameters.learning_rate",</code>
 * </p>
 * <p>
 * <code> "Operator": "LessThan",</code>
 * </p>
 * <p>
 * <code> "Value": "0.5"</code>
 * </p>
 * <p>
 * <code> }</code>
 * </p>
 * </dd>
 * <dt>Tags</dt>
 * <dd>
 * <p>
 * To define a tag filter, enter a value with the form <code>Tags.&lt;key&gt;</code>.
 * </p>
 * </dd>
 * </dl>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OPERATOR_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String operator;

    private final String value;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see
     * <a>SearchRecord</a>. You must specify a valid property for the resource.
     * </p>
     * 
     * @return A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see
     *         <a>SearchRecord</a>. You must specify a valid property for the resource.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following
     * values:
     * </p>
     * <dl>
     * <dt>Equals</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> equals <code>Value</code>.
     * </p>
     * </dd>
     * <dt>NotEquals</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> doesn't equal <code>Value</code>.
     * </p>
     * </dd>
     * <dt>GreaterThan</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>GreaterThanOrEqualTo</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>LessThan</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>LessThanOrEqualTo</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>Contains</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code> can
     * include only one <code>Contains</code> operator. Only supported for text properties.
     * </p>
     * </dd>
     * <dt>Exists</dt>
     * <dd>
     * <p>
     * The <code>Name</code> property exists.
     * </p>
     * </dd>
     * <dt>NotExists</dt>
     * <dd>
     * <p>
     * The <code>Name</code> property does not exist.
     * </p>
     * </dd>
     * <dt>In</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for
     * text properties.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
     *         following values:</p>
     *         <dl>
     *         <dt>Equals</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> equals <code>Value</code>.
     *         </p>
     *         </dd>
     *         <dt>NotEquals</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> doesn't equal <code>Value</code>.
     *         </p>
     *         </dd>
     *         <dt>GreaterThan</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>GreaterThanOrEqualTo</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
     *         properties.
     *         </p>
     *         </dd>
     *         <dt>LessThan</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>LessThanOrEqualTo</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
     *         properties.
     *         </p>
     *         </dd>
     *         <dt>Contains</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code>
     *         can include only one <code>Contains</code> operator. Only supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>Exists</dt>
     *         <dd>
     *         <p>
     *         The <code>Name</code> property exists.
     *         </p>
     *         </dd>
     *         <dt>NotExists</dt>
     *         <dd>
     *         <p>
     *         The <code>Name</code> property does not exist.
     *         </p>
     *         </dd>
     *         <dt>In</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only
     *         supported for text properties.
     *         </p>
     *         </dd>
     * @see Operator
     */
    public Operator operator() {
        return Operator.fromValue(operator);
    }

    /**
     * <p>
     * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following
     * values:
     * </p>
     * <dl>
     * <dt>Equals</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> equals <code>Value</code>.
     * </p>
     * </dd>
     * <dt>NotEquals</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> doesn't equal <code>Value</code>.
     * </p>
     * </dd>
     * <dt>GreaterThan</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>GreaterThanOrEqualTo</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>LessThan</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>LessThanOrEqualTo</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.
     * </p>
     * </dd>
     * <dt>Contains</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code> can
     * include only one <code>Contains</code> operator. Only supported for text properties.
     * </p>
     * </dd>
     * <dt>Exists</dt>
     * <dd>
     * <p>
     * The <code>Name</code> property exists.
     * </p>
     * </dd>
     * <dt>NotExists</dt>
     * <dd>
     * <p>
     * The <code>Name</code> property does not exist.
     * </p>
     * </dd>
     * <dt>In</dt>
     * <dd>
     * <p>
     * The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for
     * text properties.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
     *         following values:</p>
     *         <dl>
     *         <dt>Equals</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> equals <code>Value</code>.
     *         </p>
     *         </dd>
     *         <dt>NotEquals</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> doesn't equal <code>Value</code>.
     *         </p>
     *         </dd>
     *         <dt>GreaterThan</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>GreaterThanOrEqualTo</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
     *         properties.
     *         </p>
     *         </dd>
     *         <dt>LessThan</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>LessThanOrEqualTo</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
     *         properties.
     *         </p>
     *         </dd>
     *         <dt>Contains</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code>
     *         can include only one <code>Contains</code> operator. Only supported for text properties.
     *         </p>
     *         </dd>
     *         <dt>Exists</dt>
     *         <dd>
     *         <p>
     *         The <code>Name</code> property exists.
     *         </p>
     *         </dd>
     *         <dt>NotExists</dt>
     *         <dd>
     *         <p>
     *         The <code>Name</code> property does not exist.
     *         </p>
     *         </dd>
     *         <dt>In</dt>
     *         <dd>
     *         <p>
     *         The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only
     *         supported for text properties.
     *         </p>
     *         </dd>
     * @see Operator
     */
    public String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the filter's
     * condition. For numerical properties, <code>Value</code> must be an integer or floating-point decimal. For
     * timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following format:
     * <code>YYYY-mm-dd'T'HH:MM:SS</code>.
     * </p>
     * 
     * @return A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the
     *         filter's condition. For numerical properties, <code>Value</code> must be an integer or floating-point
     *         decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the
     *         following format: <code>YYYY-mm-dd'T'HH:MM:SS</code>.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Filter").add("Name", name()).add("Operator", operatorAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see
         * <a>SearchRecord</a>. You must specify a valid property for the resource.
         * </p>
         * 
         * @param name
         *        A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see
         *        <a>SearchRecord</a>. You must specify a valid property for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
         * following values:
         * </p>
         * <dl>
         * <dt>Equals</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> equals <code>Value</code>.
         * </p>
         * </dd>
         * <dt>NotEquals</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> doesn't equal <code>Value</code>.
         * </p>
         * </dd>
         * <dt>GreaterThan</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
         * </p>
         * </dd>
         * <dt>GreaterThanOrEqualTo</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
         * properties.
         * </p>
         * </dd>
         * <dt>LessThan</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
         * </p>
         * </dd>
         * <dt>LessThanOrEqualTo</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
         * properties.
         * </p>
         * </dd>
         * <dt>Contains</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code> can
         * include only one <code>Contains</code> operator. Only supported for text properties.
         * </p>
         * </dd>
         * <dt>Exists</dt>
         * <dd>
         * <p>
         * The <code>Name</code> property exists.
         * </p>
         * </dd>
         * <dt>NotExists</dt>
         * <dd>
         * <p>
         * The <code>Name</code> property does not exist.
         * </p>
         * </dd>
         * <dt>In</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported
         * for text properties.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param operator
         *        A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
         *        following values:</p>
         *        <dl>
         *        <dt>Equals</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> equals <code>Value</code>.
         *        </p>
         *        </dd>
         *        <dt>NotEquals</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> doesn't equal <code>Value</code>.
         *        </p>
         *        </dd>
         *        <dt>GreaterThan</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>GreaterThanOrEqualTo</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
         *        properties.
         *        </p>
         *        </dd>
         *        <dt>LessThan</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>LessThanOrEqualTo</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
         *        properties.
         *        </p>
         *        </dd>
         *        <dt>Contains</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code>
         *        can include only one <code>Contains</code> operator. Only supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>Exists</dt>
         *        <dd>
         *        <p>
         *        The <code>Name</code> property exists.
         *        </p>
         *        </dd>
         *        <dt>NotExists</dt>
         *        <dd>
         *        <p>
         *        The <code>Name</code> property does not exist.
         *        </p>
         *        </dd>
         *        <dt>In</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only
         *        supported for text properties.
         *        </p>
         *        </dd>
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(String operator);

        /**
         * <p>
         * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
         * following values:
         * </p>
         * <dl>
         * <dt>Equals</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> equals <code>Value</code>.
         * </p>
         * </dd>
         * <dt>NotEquals</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> doesn't equal <code>Value</code>.
         * </p>
         * </dd>
         * <dt>GreaterThan</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
         * </p>
         * </dd>
         * <dt>GreaterThanOrEqualTo</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
         * properties.
         * </p>
         * </dd>
         * <dt>LessThan</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
         * </p>
         * </dd>
         * <dt>LessThanOrEqualTo</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
         * properties.
         * </p>
         * </dd>
         * <dt>Contains</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code> can
         * include only one <code>Contains</code> operator. Only supported for text properties.
         * </p>
         * </dd>
         * <dt>Exists</dt>
         * <dd>
         * <p>
         * The <code>Name</code> property exists.
         * </p>
         * </dd>
         * <dt>NotExists</dt>
         * <dd>
         * <p>
         * The <code>Name</code> property does not exist.
         * </p>
         * </dd>
         * <dt>In</dt>
         * <dd>
         * <p>
         * The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported
         * for text properties.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param operator
         *        A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the
         *        following values:</p>
         *        <dl>
         *        <dt>Equals</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> equals <code>Value</code>.
         *        </p>
         *        </dd>
         *        <dt>NotEquals</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> doesn't equal <code>Value</code>.
         *        </p>
         *        </dd>
         *        <dt>GreaterThan</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>GreaterThanOrEqualTo</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text
         *        properties.
         *        </p>
         *        </dd>
         *        <dt>LessThan</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>LessThanOrEqualTo</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text
         *        properties.
         *        </p>
         *        </dd>
         *        <dt>Contains</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> contains the string <code>Value</code>. A <code>SearchExpression</code>
         *        can include only one <code>Contains</code> operator. Only supported for text properties.
         *        </p>
         *        </dd>
         *        <dt>Exists</dt>
         *        <dd>
         *        <p>
         *        The <code>Name</code> property exists.
         *        </p>
         *        </dd>
         *        <dt>NotExists</dt>
         *        <dd>
         *        <p>
         *        The <code>Name</code> property does not exist.
         *        </p>
         *        </dd>
         *        <dt>In</dt>
         *        <dd>
         *        <p>
         *        The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only
         *        supported for text properties.
         *        </p>
         *        </dd>
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(Operator operator);

        /**
         * <p>
         * A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the
         * filter's condition. For numerical properties, <code>Value</code> must be an integer or floating-point
         * decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following
         * format: <code>YYYY-mm-dd'T'HH:MM:SS</code>.
         * </p>
         * 
         * @param value
         *        A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the
         *        filter's condition. For numerical properties, <code>Value</code> must be an integer or floating-point
         *        decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the
         *        following format: <code>YYYY-mm-dd'T'HH:MM:SS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            name(model.name);
            operator(model.operator);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
