/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotebookInstanceResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeNotebookInstanceResponse.Builder, DescribeNotebookInstanceResponse> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceArn)).setter(setter(Builder::notebookInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceName)).setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceStatusAsString))
            .setter(setter(Builder::notebookInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotebookInstanceResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotebookInstanceResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotebookInstanceResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::directInternetAccessAsString))
            .setter(setter(Builder::directInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeNotebookInstanceResponse::volumeSizeInGB)).setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotebookInstanceResponse::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::defaultCodeRepository))
            .setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotebookInstanceResponse::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotebookInstanceResponse::rootAccessAsString)).setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_ARN_FIELD,
            NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, FAILURE_REASON_FIELD, URL_FIELD, INSTANCE_TYPE_FIELD,
            SUBNET_ID_FIELD, SECURITY_GROUPS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD,
            DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD, ACCELERATOR_TYPES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD,
            ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD));

    private final String notebookInstanceArn;

    private final String notebookInstanceName;

    private final String notebookInstanceStatus;

    private final String failureReason;

    private final String url;

    private final String instanceType;

    private final String subnetId;

    private final List<String> securityGroups;

    private final String roleArn;

    private final String kmsKeyId;

    private final String networkInterfaceId;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final String notebookInstanceLifecycleConfigName;

    private final String directInternetAccess;

    private final Integer volumeSizeInGB;

    private final List<String> acceleratorTypes;

    private final String defaultCodeRepository;

    private final List<String> additionalCodeRepositories;

    private final String rootAccess;

    private DescribeNotebookInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroups = builder.securityGroups;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notebook instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notebook instance.
     */
    public String notebookInstanceArn() {
        return notebookInstanceArn;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker notebook instance.
     * </p>
     * 
     * @return The name of the Amazon SageMaker notebook instance.
     */
    public String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The status of the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookInstanceStatus} will return {@link NotebookInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookInstanceStatusAsString}.
     * </p>
     * 
     * @return The status of the notebook instance.
     * @see NotebookInstanceStatus
     */
    public NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(notebookInstanceStatus);
    }

    /**
     * <p>
     * The status of the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookInstanceStatus} will return {@link NotebookInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookInstanceStatusAsString}.
     * </p>
     * 
     * @return The status of the notebook instance.
     * @see NotebookInstanceStatus
     */
    public String notebookInstanceStatusAsString() {
        return notebookInstanceStatus;
    }

    /**
     * <p>
     * If status is <code>Failed</code>, the reason it failed.
     * </p>
     * 
     * @return If status is <code>Failed</code>, the reason it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     * </p>
     * 
     * @return The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The type of ML compute instance running on the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance running on the notebook instance.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of ML compute instance running on the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance running on the notebook instance.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the VPC subnet.
     * </p>
     * 
     * @return The ID of the VPC subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the VPC security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the VPC security groups.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the
     * instance.
     * </p>
     * 
     * @return The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume
     *         attached to the instance.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The network interface IDs that Amazon SageMaker created at the time of creating the instance.
     * </p>
     * 
     * @return The network interface IDs that Amazon SageMaker created at the time of creating the instance.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
     * </p>
     * 
     * @return A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A timestamp. Use this parameter to return the time when the notebook instance was created
     * </p>
     * 
     * @return A timestamp. Use this parameter to return the time when the notebook instance was created
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Returns the name of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>
     * </p>
     * 
     * @return Returns the name of a notebook instance lifecycle configuration.</p>
     *         <p>
     *         For information about notebook instance lifestyle configurations, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
     *         (Optional) Customize a Notebook Instance</a>
     */
    public String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to
     * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker
     * training and endpoint services.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is
     *         set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon
     *         SageMaker training and endpoint services.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>.
     * @see DirectInternetAccess
     */
    public DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(directInternetAccess);
    }

    /**
     * <p>
     * Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to
     * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker
     * training and endpoint services.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is
     *         set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon
     *         SageMaker training and endpoint services.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>.
     * @see DirectInternetAccess
     */
    public String directInternetAccessAsString() {
        return directInternetAccess;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume attached to the notebook instance.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume attached to the notebook instance.
     */
    public Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI
     * instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
     *         only one EI instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * Returns true if the AcceleratorTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI
     * instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
     *         only one EI instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * The Git repository associated with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For
     * more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
     * Repositories with Amazon SageMaker Notebook Instances</a>.
     * </p>
     * 
     * @return The Git repository associated with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
     *         in any other Git repository. When you open a notebook instance, it opens in the directory that contains
     *         this repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * Returns true if the AdditionalCodeRepositories property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of
     * Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository. These repositories are cloned at the same level as the default repository of your notebook
     * instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon
     * SageMaker Notebook Instances</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalCodeRepositories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of up to three Git repositories associated with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
     *         other Git repository. These repositories are cloned at the same level as the default repository of your
     *         notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public RootAccess rootAccess() {
        return RootAccess.fromValue(rootAccess);
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public String rootAccessAsString() {
        return rootAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(additionalCodeRepositories());
        hashCode = 31 * hashCode + Objects.hashCode(rootAccessAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceResponse)) {
            return false;
        }
        DescribeNotebookInstanceResponse other = (DescribeNotebookInstanceResponse) obj;
        return Objects.equals(notebookInstanceArn(), other.notebookInstanceArn())
                && Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(notebookInstanceStatusAsString(), other.notebookInstanceStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(url(), other.url())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && Objects.equals(directInternetAccessAsString(), other.directInternetAccessAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(rootAccessAsString(), other.rootAccessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotebookInstanceResponse").add("NotebookInstanceArn", notebookInstanceArn())
                .add("NotebookInstanceName", notebookInstanceName())
                .add("NotebookInstanceStatus", notebookInstanceStatusAsString()).add("FailureReason", failureReason())
                .add("Url", url()).add("InstanceType", instanceTypeAsString()).add("SubnetId", subnetId())
                .add("SecurityGroups", securityGroups()).add("RoleArn", roleArn()).add("KmsKeyId", kmsKeyId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("LastModifiedTime", lastModifiedTime())
                .add("CreationTime", creationTime())
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName())
                .add("DirectInternetAccess", directInternetAccessAsString()).add("VolumeSizeInGB", volumeSizeInGB())
                .add("AcceleratorTypes", acceleratorTypesAsStrings()).add("DefaultCodeRepository", defaultCodeRepository())
                .add("AdditionalCodeRepositories", additionalCodeRepositories()).add("RootAccess", rootAccessAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceArn":
            return Optional.ofNullable(clazz.cast(notebookInstanceArn()));
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "NotebookInstanceStatus":
            return Optional.ofNullable(clazz.cast(notebookInstanceStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "DirectInternetAccess":
            return Optional.ofNullable(clazz.cast(directInternetAccessAsString()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookInstanceResponse, T> g) {
        return obj -> g.apply((DescribeNotebookInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceArn
         *        The Amazon Resource Name (ARN) of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceArn(String notebookInstanceArn);

        /**
         * <p>
         * The name of the Amazon SageMaker notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the Amazon SageMaker notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The status of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceStatus
         *        The status of the notebook instance.
         * @see NotebookInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceStatus
         */
        Builder notebookInstanceStatus(String notebookInstanceStatus);

        /**
         * <p>
         * The status of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceStatus
         *        The status of the notebook instance.
         * @see NotebookInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceStatus
         */
        Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus);

        /**
         * <p>
         * If status is <code>Failed</code>, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If status is <code>Failed</code>, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * </p>
         * 
         * @param url
         *        The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The type of ML compute instance running on the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance running on the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of ML compute instance running on the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance running on the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the VPC subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the VPC subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IDs of the VPC security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the VPC security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the VPC security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the VPC security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to
         * the instance.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume
         *        attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The network interface IDs that Amazon SageMaker created at the time of creating the instance.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface IDs that Amazon SageMaker created at the time of creating the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A timestamp. Use this parameter to return the time when the notebook instance was created
         * </p>
         * 
         * @param creationTime
         *        A timestamp. Use this parameter to return the time when the notebook instance was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Returns the name of a notebook instance lifecycle configuration.
         * </p>
         * <p>
         * For information about notebook instance lifestyle configurations, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance</a>
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        Returns the name of a notebook instance lifecycle configuration.</p>
         *        <p>
         *        For information about notebook instance lifestyle configurations, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
         *        (Optional) Customize a Notebook Instance</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to
         * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker
         * training and endpoint services.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>.
         * </p>
         * 
         * @param directInternetAccess
         *        Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is
         *        set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to
         *        Amazon SageMaker training and endpoint services.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(String directInternetAccess);

        /**
         * <p>
         * Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to
         * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker
         * training and endpoint services.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>.
         * </p>
         * 
         * @param directInternetAccess
         *        Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is
         *        set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to
         *        Amazon SageMaker training and endpoint services.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(DirectInternetAccess directInternetAccess);

        /**
         * <p>
         * The size, in GB, of the ML storage volume attached to the notebook instance.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume attached to the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
         *        only one EI instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
         *        only one EI instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
         *        only one EI instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently
         *        only one EI instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes);

        /**
         * <p>
         * The Git repository associated with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. When you open a notebook instance, it opens in the directory that contains this
         * repository. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        The Git repository associated with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS
         *        CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the
         *        directory that contains this repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. These repositories are cloned at the same level as the default repository of your
         * notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
         *        in any other Git repository. These repositories are cloned at the same level as the default repository
         *        of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. These repositories are cloned at the same level as the default repository of your
         * notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
         *        in any other Git repository. These repositories are cloned at the same level as the default repository
         *        of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(RootAccess rootAccess);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String notebookInstanceArn;

        private String notebookInstanceName;

        private String notebookInstanceStatus;

        private String failureReason;

        private String url;

        private String instanceType;

        private String subnetId;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String kmsKeyId;

        private String networkInterfaceId;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private String notebookInstanceLifecycleConfigName;

        private String directInternetAccess;

        private Integer volumeSizeInGB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private String defaultCodeRepository;

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String rootAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceResponse model) {
            super(model);
            notebookInstanceArn(model.notebookInstanceArn);
            notebookInstanceName(model.notebookInstanceName);
            notebookInstanceStatus(model.notebookInstanceStatus);
            failureReason(model.failureReason);
            url(model.url);
            instanceType(model.instanceType);
            subnetId(model.subnetId);
            securityGroups(model.securityGroups);
            roleArn(model.roleArn);
            kmsKeyId(model.kmsKeyId);
            networkInterfaceId(model.networkInterfaceId);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            directInternetAccess(model.directInternetAccess);
            volumeSizeInGB(model.volumeSizeInGB);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            defaultCodeRepository(model.defaultCodeRepository);
            additionalCodeRepositories(model.additionalCodeRepositories);
            rootAccess(model.rootAccess);
        }

        public final String getNotebookInstanceArn() {
            return notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getNotebookInstanceStatus() {
            return notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus == null ? null : notebookInstanceStatus.toString());
            return this;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public final String getDirectInternetAccess() {
            return directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final Collection<String> getAcceleratorTypes() {
            return acceleratorTypes;
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            return additionalCodeRepositories;
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public DescribeNotebookInstanceResponse build() {
            return new DescribeNotebookInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
