/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelPackageRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelPackageRequest.Builder, CreateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateModelPackageRequest::modelPackageName)).setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateModelPackageRequest::modelPackageDescription)).setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateModelPackageRequest::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField
            .<ModelPackageValidationSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateModelPackageRequest::validationSpecification)).setter(setter(Builder::validationSpecification))
            .constructor(ModelPackageValidationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build())
            .build();

    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<SourceAlgorithmSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateModelPackageRequest::sourceAlgorithmSpecification))
            .setter(setter(Builder::sourceAlgorithmSpecification))
            .constructor(SourceAlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification")
                    .build()).build();

    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateModelPackageRequest::certifyForMarketplace)).setter(setter(Builder::certifyForMarketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD,
            MODEL_PACKAGE_DESCRIPTION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD,
            SOURCE_ALGORITHM_SPECIFICATION_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));

    private final String modelPackageName;

    private final String modelPackageDescription;

    private final InferenceSpecification inferenceSpecification;

    private final ModelPackageValidationSpecification validationSpecification;

    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;

    private final Boolean certifyForMarketplace;

    private CreateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    /**
     * <p>
     * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @return The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9,
     *         and - (hyphen).
     */
    public String modelPackageName() {
        return modelPackageName;
    }

    /**
     * <p>
     * A description of the model package.
     * </p>
     * 
     * @return A description of the model package.
     */
    public String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * Specifies details about inference jobs that can be run with models based on this model package, including the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon ECR paths of containers that contain the inference code and model artifacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
     * </p>
     * </li>
     * <li>
     * <p>
     * The input and output content formats that the model package supports for inference.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies details about inference jobs that can be run with models based on this model package, including
     *         the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The Amazon ECR paths of containers that contain the inference code and model artifacts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The instance types that the model package supports for transform jobs and real-time endpoints used for
     *         inference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input and output content formats that the model package supports for inference.
     *         </p>
     *         </li>
     */
    public InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
     * </p>
     * 
     * @return Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model
     *         package.
     */
    public ModelPackageValidationSpecification validationSpecification() {
        return validationSpecification;
    }

    /**
     * <p>
     * Details about the algorithm that was used to create the model package.
     * </p>
     * 
     * @return Details about the algorithm that was used to create the model package.
     */
    public SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return sourceAlgorithmSpecification;
    }

    /**
     * <p>
     * Whether to certify the model package for listing on AWS Marketplace.
     * </p>
     * 
     * @return Whether to certify the model package for listing on AWS Marketplace.
     */
    public Boolean certifyForMarketplace() {
        return certifyForMarketplace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(certifyForMarketplace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelPackageRequest)) {
            return false;
        }
        CreateModelPackageRequest other = (CreateModelPackageRequest) obj;
        return Objects.equals(modelPackageName(), other.modelPackageName())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(validationSpecification(), other.validationSpecification())
                && Objects.equals(sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification())
                && Objects.equals(certifyForMarketplace(), other.certifyForMarketplace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateModelPackageRequest").add("ModelPackageName", modelPackageName())
                .add("ModelPackageDescription", modelPackageDescription())
                .add("InferenceSpecification", inferenceSpecification())
                .add("ValidationSpecification", validationSpecification())
                .add("SourceAlgorithmSpecification", sourceAlgorithmSpecification())
                .add("CertifyForMarketplace", certifyForMarketplace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "ValidationSpecification":
            return Optional.ofNullable(clazz.cast(validationSpecification()));
        case "SourceAlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(sourceAlgorithmSpecification()));
        case "CertifyForMarketplace":
            return Optional.ofNullable(clazz.cast(certifyForMarketplace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelPackageRequest, T> g) {
        return obj -> g.apply((CreateModelPackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelPackageRequest> {
        /**
         * <p>
         * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and
         * - (hyphen).
         * </p>
         * 
         * @param modelPackageName
         *        The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z,
         *        0-9, and - (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);

        /**
         * <p>
         * A description of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        A description of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * Specifies details about inference jobs that can be run with models based on this model package, including the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance types that the model package supports for transform jobs and real-time endpoints used for
         * inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * The input and output content formats that the model package supports for inference.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inferenceSpecification
         *        Specifies details about inference jobs that can be run with models based on this model package,
         *        including the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The Amazon ECR paths of containers that contain the inference code and model artifacts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The instance types that the model package supports for transform jobs and real-time endpoints used for
         *        inference.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The input and output content formats that the model package supports for inference.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * <p>
         * Specifies details about inference jobs that can be run with models based on this model package, including the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance types that the model package supports for transform jobs and real-time endpoints used for
         * inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * The input and output content formats that the model package supports for inference.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link InferenceSpecification.Builder} avoiding the
         * need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
         * </p>
         * 
         * @param validationSpecification
         *        Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model
         *        package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSpecification(ModelPackageValidationSpecification validationSpecification);

        /**
         * <p>
         * Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackageValidationSpecification.Builder}
         * avoiding the need to create one manually via {@link ModelPackageValidationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageValidationSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #validationSpecification(ModelPackageValidationSpecification)}
         * .
         * 
         * @param validationSpecification
         *        a consumer that will call methods on {@link ModelPackageValidationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSpecification(ModelPackageValidationSpecification)
         */
        default Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return validationSpecification(ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)
                    .build());
        }

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * 
         * @param sourceAlgorithmSpecification
         *        Details about the algorithm that was used to create the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification);

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceAlgorithmSpecification.Builder} avoiding
         * the need to create one manually via {@link SourceAlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAlgorithmSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAlgorithmSpecification(SourceAlgorithmSpecification)}.
         * 
         * @param sourceAlgorithmSpecification
         *        a consumer that will call methods on {@link SourceAlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAlgorithmSpecification(SourceAlgorithmSpecification)
         */
        default Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return sourceAlgorithmSpecification(SourceAlgorithmSpecification.builder()
                    .applyMutation(sourceAlgorithmSpecification).build());
        }

        /**
         * <p>
         * Whether to certify the model package for listing on AWS Marketplace.
         * </p>
         * 
         * @param certifyForMarketplace
         *        Whether to certify the model package for listing on AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifyForMarketplace(Boolean certifyForMarketplace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelPackageName;

        private String modelPackageDescription;

        private InferenceSpecification inferenceSpecification;

        private ModelPackageValidationSpecification validationSpecification;

        private SourceAlgorithmSpecification sourceAlgorithmSpecification;

        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelPackageRequest model) {
            super(model);
            modelPackageName(model.modelPackageName);
            modelPackageDescription(model.modelPackageDescription);
            inferenceSpecification(model.inferenceSpecification);
            validationSpecification(model.validationSpecification);
            sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return validationSpecification != null ? validationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build()
                    : null;
        }

        public final Boolean getCertifyForMarketplace() {
            return certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelPackageRequest build() {
            return new CreateModelPackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
