/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AlgorithmStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AlgorithmStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlgorithmStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AlgorithmStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlgorithmStatus> knownValues() {
        return Stream.of(AlgorithmStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

