/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelPackageResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelPackageResponse> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::modelPackageName)).setter(DescribeModelPackageResponse.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::modelPackageArn)).setter(DescribeModelPackageResponse.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::modelPackageDescription)).setter(DescribeModelPackageResponse.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::creationTime)).setter(DescribeModelPackageResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::inferenceSpecification)).setter(DescribeModelPackageResponse.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::sourceAlgorithmSpecification)).setter(DescribeModelPackageResponse.setter(Builder::sourceAlgorithmSpecification)).constructor(SourceAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification").build()}).build();
    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::validationSpecification)).setter(DescribeModelPackageResponse.setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::modelPackageStatusAsString)).setter(DescribeModelPackageResponse.setter(Builder::modelPackageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build()}).build();
    private static final SdkField<ModelPackageStatusDetails> MODEL_PACKAGE_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::modelPackageStatusDetails)).setter(DescribeModelPackageResponse.setter(Builder::modelPackageStatusDetails)).constructor(ModelPackageStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatusDetails").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeModelPackageResponse.getter(DescribeModelPackageResponse::certifyForMarketplace)).setter(DescribeModelPackageResponse.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD, SOURCE_ALGORITHM_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD, MODEL_PACKAGE_STATUS_DETAILS_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));
    private final String modelPackageName;
    private final String modelPackageArn;
    private final String modelPackageDescription;
    private final Instant creationTime;
    private final InferenceSpecification inferenceSpecification;
    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;
    private final ModelPackageValidationSpecification validationSpecification;
    private final String modelPackageStatus;
    private final ModelPackageStatusDetails modelPackageStatusDetails;
    private final Boolean certifyForMarketplace;

    private DescribeModelPackageResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    public String modelPackageName() {
        return this.modelPackageName;
    }

    public String modelPackageArn() {
        return this.modelPackageArn;
    }

    public String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return this.sourceAlgorithmSpecification;
    }

    public ModelPackageValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(this.modelPackageStatus);
    }

    public String modelPackageStatusAsString() {
        return this.modelPackageStatus;
    }

    public ModelPackageStatusDetails modelPackageStatusDetails() {
        return this.modelPackageStatusDetails;
    }

    public Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackageResponse)) {
            return false;
        }
        DescribeModelPackageResponse other = (DescribeModelPackageResponse)((Object)obj);
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.modelPackageStatusAsString(), other.modelPackageStatusAsString()) && Objects.equals(this.modelPackageStatusDetails(), other.modelPackageStatusDetails()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace());
    }

    public String toString() {
        return ToString.builder((String)"DescribeModelPackageResponse").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("CreationTime", (Object)this.creationTime()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("SourceAlgorithmSpecification", (Object)this.sourceAlgorithmSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("ModelPackageStatus", (Object)this.modelPackageStatusAsString()).add("ModelPackageStatusDetails", (Object)this.modelPackageStatusDetails()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "SourceAlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithmSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "ModelPackageStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusAsString()));
            }
            case "ModelPackageStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusDetails()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackageResponse, T> g) {
        return obj -> g.apply((DescribeModelPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageArn;
        private String modelPackageDescription;
        private Instant creationTime;
        private InferenceSpecification inferenceSpecification;
        private SourceAlgorithmSpecification sourceAlgorithmSpecification;
        private ModelPackageValidationSpecification validationSpecification;
        private String modelPackageStatus;
        private ModelPackageStatusDetails modelPackageStatusDetails;
        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackageResponse model) {
            super(model);
            this.modelPackageName(model.modelPackageName);
            this.modelPackageArn(model.modelPackageArn);
            this.modelPackageDescription(model.modelPackageDescription);
            this.creationTime(model.creationTime);
            this.inferenceSpecification(model.inferenceSpecification);
            this.sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            this.validationSpecification(model.validationSpecification);
            this.modelPackageStatus(model.modelPackageStatus);
            this.modelPackageStatusDetails(model.modelPackageStatusDetails);
            this.certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build() : null;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        public final String getModelPackageStatusAsString() {
            return this.modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        public final ModelPackageStatusDetails.Builder getModelPackageStatusDetails() {
            return this.modelPackageStatusDetails != null ? this.modelPackageStatusDetails.toBuilder() : null;
        }

        @Override
        public final Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        public final void setModelPackageStatusDetails(ModelPackageStatusDetails.BuilderImpl modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails != null ? modelPackageStatusDetails.build() : null;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public DescribeModelPackageResponse build() {
            return new DescribeModelPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelPackageResponse> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageArn(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification var1);

        default public Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return this.sourceAlgorithmSpecification((SourceAlgorithmSpecification)((SourceAlgorithmSpecification.Builder)SourceAlgorithmSpecification.builder().applyMutation(sourceAlgorithmSpecification)).build());
        }

        public Builder validationSpecification(ModelPackageValidationSpecification var1);

        default public Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((ModelPackageValidationSpecification)((ModelPackageValidationSpecification.Builder)ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder modelPackageStatus(String var1);

        public Builder modelPackageStatus(ModelPackageStatus var1);

        public Builder modelPackageStatusDetails(ModelPackageStatusDetails var1);

        default public Builder modelPackageStatusDetails(Consumer<ModelPackageStatusDetails.Builder> modelPackageStatusDetails) {
            return this.modelPackageStatusDetails((ModelPackageStatusDetails)((ModelPackageStatusDetails.Builder)ModelPackageStatusDetails.builder().applyMutation(modelPackageStatusDetails)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);
    }
}

