/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.TransformJobDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmValidationProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmValidationProfile> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmValidationProfile.getter(AlgorithmValidationProfile::profileName)).setter(AlgorithmValidationProfile.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<TrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AlgorithmValidationProfile.getter(AlgorithmValidationProfile::trainingJobDefinition)).setter(AlgorithmValidationProfile.setter(Builder::trainingJobDefinition)).constructor(TrainingJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build()}).build();
    private static final SdkField<TransformJobDefinition> TRANSFORM_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AlgorithmValidationProfile.getter(AlgorithmValidationProfile::transformJobDefinition)).setter(AlgorithmValidationProfile.setter(Builder::transformJobDefinition)).constructor(TransformJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, TRAINING_JOB_DEFINITION_FIELD, TRANSFORM_JOB_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileName;
    private final TrainingJobDefinition trainingJobDefinition;
    private final TransformJobDefinition transformJobDefinition;

    private AlgorithmValidationProfile(BuilderImpl builder) {
        this.profileName = builder.profileName;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.transformJobDefinition = builder.transformJobDefinition;
    }

    public String profileName() {
        return this.profileName;
    }

    public TrainingJobDefinition trainingJobDefinition() {
        return this.trainingJobDefinition;
    }

    public TransformJobDefinition transformJobDefinition() {
        return this.transformJobDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobDefinition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmValidationProfile)) {
            return false;
        }
        AlgorithmValidationProfile other = (AlgorithmValidationProfile)obj;
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.trainingJobDefinition(), other.trainingJobDefinition()) && Objects.equals(this.transformJobDefinition(), other.transformJobDefinition());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmValidationProfile").add("ProfileName", (Object)this.profileName()).add("TrainingJobDefinition", (Object)this.trainingJobDefinition()).add("TransformJobDefinition", (Object)this.transformJobDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "TrainingJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinition()));
            }
            case "TransformJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.transformJobDefinition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmValidationProfile, T> g) {
        return obj -> g.apply((AlgorithmValidationProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileName;
        private TrainingJobDefinition trainingJobDefinition;
        private TransformJobDefinition transformJobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmValidationProfile model) {
            this.profileName(model.profileName);
            this.trainingJobDefinition(model.trainingJobDefinition);
            this.transformJobDefinition(model.transformJobDefinition);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final TrainingJobDefinition.Builder getTrainingJobDefinition() {
            return this.trainingJobDefinition != null ? this.trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(TrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(TrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final TransformJobDefinition.Builder getTransformJobDefinition() {
            return this.transformJobDefinition != null ? this.transformJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder transformJobDefinition(TransformJobDefinition transformJobDefinition) {
            this.transformJobDefinition = transformJobDefinition;
            return this;
        }

        public final void setTransformJobDefinition(TransformJobDefinition.BuilderImpl transformJobDefinition) {
            this.transformJobDefinition = transformJobDefinition != null ? transformJobDefinition.build() : null;
        }

        public AlgorithmValidationProfile build() {
            return new AlgorithmValidationProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmValidationProfile> {
        public Builder profileName(String var1);

        public Builder trainingJobDefinition(TrainingJobDefinition var1);

        default public Builder trainingJobDefinition(Consumer<TrainingJobDefinition.Builder> trainingJobDefinition) {
            return this.trainingJobDefinition((TrainingJobDefinition)((TrainingJobDefinition.Builder)TrainingJobDefinition.builder().applyMutation(trainingJobDefinition)).build());
        }

        public Builder transformJobDefinition(TransformJobDefinition var1);

        default public Builder transformJobDefinition(Consumer<TransformJobDefinition.Builder> transformJobDefinition) {
            return this.transformJobDefinition((TransformJobDefinition)((TransformJobDefinition.Builder)TransformJobDefinition.builder().applyMutation(transformJobDefinition)).build());
        }
    }
}

