/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specified in the <a>GetSearchSuggestions</a> request. Limits the property names that are included in the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestionQuery implements SdkPojo, Serializable, ToCopyableBuilder<SuggestionQuery.Builder, SuggestionQuery> {
    private static final SdkField<PropertyNameQuery> PROPERTY_NAME_QUERY_FIELD = SdkField
            .<PropertyNameQuery> builder(MarshallingType.SDK_POJO).getter(getter(SuggestionQuery::propertyNameQuery))
            .setter(setter(Builder::propertyNameQuery)).constructor(PropertyNameQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyNameQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final PropertyNameQuery propertyNameQuery;

    private SuggestionQuery(BuilderImpl builder) {
        this.propertyNameQuery = builder.propertyNameQuery;
    }

    /**
     * <p>
     * Defines a property name hint. Only property names that begin with the specified hint are included in the
     * response.
     * </p>
     * 
     * @return Defines a property name hint. Only property names that begin with the specified hint are included in the
     *         response.
     */
    public PropertyNameQuery propertyNameQuery() {
        return propertyNameQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyNameQuery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionQuery)) {
            return false;
        }
        SuggestionQuery other = (SuggestionQuery) obj;
        return Objects.equals(propertyNameQuery(), other.propertyNameQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SuggestionQuery").add("PropertyNameQuery", propertyNameQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyNameQuery":
            return Optional.ofNullable(clazz.cast(propertyNameQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestionQuery, T> g) {
        return obj -> g.apply((SuggestionQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestionQuery> {
        /**
         * <p>
         * Defines a property name hint. Only property names that begin with the specified hint are included in the
         * response.
         * </p>
         * 
         * @param propertyNameQuery
         *        Defines a property name hint. Only property names that begin with the specified hint are included in
         *        the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyNameQuery(PropertyNameQuery propertyNameQuery);

        /**
         * <p>
         * Defines a property name hint. Only property names that begin with the specified hint are included in the
         * response.
         * </p>
         * This is a convenience that creates an instance of the {@link PropertyNameQuery.Builder} avoiding the need to
         * create one manually via {@link PropertyNameQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyNameQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #propertyNameQuery(PropertyNameQuery)}.
         * 
         * @param propertyNameQuery
         *        a consumer that will call methods on {@link PropertyNameQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyNameQuery(PropertyNameQuery)
         */
        default Builder propertyNameQuery(Consumer<PropertyNameQuery.Builder> propertyNameQuery) {
            return propertyNameQuery(PropertyNameQuery.builder().applyMutation(propertyNameQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PropertyNameQuery propertyNameQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionQuery model) {
            propertyNameQuery(model.propertyNameQuery);
        }

        public final PropertyNameQuery.Builder getPropertyNameQuery() {
            return propertyNameQuery != null ? propertyNameQuery.toBuilder() : null;
        }

        @Override
        public final Builder propertyNameQuery(PropertyNameQuery propertyNameQuery) {
            this.propertyNameQuery = propertyNameQuery;
            return this;
        }

        public final void setPropertyNameQuery(PropertyNameQuery.BuilderImpl propertyNameQuery) {
            this.propertyNameQuery = propertyNameQuery != null ? propertyNameQuery.build() : null;
        }

        @Override
        public SuggestionQuery build() {
            return new SuggestionQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
