/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the resources to deploy for a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringResources implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringResources.Builder, MonitoringResources> {
    private static final SdkField<MonitoringClusterConfig> CLUSTER_CONFIG_FIELD = SdkField
            .<MonitoringClusterConfig> builder(MarshallingType.SDK_POJO).getter(getter(MonitoringResources::clusterConfig))
            .setter(setter(Builder::clusterConfig)).constructor(MonitoringClusterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final MonitoringClusterConfig clusterConfig;

    private MonitoringResources(BuilderImpl builder) {
        this.clusterConfig = builder.clusterConfig;
    }

    /**
     * <p>
     * The configuration for the cluster resources used to run the processing job.
     * </p>
     * 
     * @return The configuration for the cluster resources used to run the processing job.
     */
    public MonitoringClusterConfig clusterConfig() {
        return clusterConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringResources)) {
            return false;
        }
        MonitoringResources other = (MonitoringResources) obj;
        return Objects.equals(clusterConfig(), other.clusterConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitoringResources").add("ClusterConfig", clusterConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterConfig":
            return Optional.ofNullable(clazz.cast(clusterConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringResources, T> g) {
        return obj -> g.apply((MonitoringResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringResources> {
        /**
         * <p>
         * The configuration for the cluster resources used to run the processing job.
         * </p>
         * 
         * @param clusterConfig
         *        The configuration for the cluster resources used to run the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfig(MonitoringClusterConfig clusterConfig);

        /**
         * <p>
         * The configuration for the cluster resources used to run the processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringClusterConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringClusterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringClusterConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterConfig(MonitoringClusterConfig)}.
         * 
         * @param clusterConfig
         *        a consumer that will call methods on {@link MonitoringClusterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfig(MonitoringClusterConfig)
         */
        default Builder clusterConfig(Consumer<MonitoringClusterConfig.Builder> clusterConfig) {
            return clusterConfig(MonitoringClusterConfig.builder().applyMutation(clusterConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MonitoringClusterConfig clusterConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringResources model) {
            clusterConfig(model.clusterConfig);
        }

        public final MonitoringClusterConfig.Builder getClusterConfig() {
            return clusterConfig != null ? clusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder clusterConfig(MonitoringClusterConfig clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final void setClusterConfig(MonitoringClusterConfig.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public MonitoringResources build() {
            return new MonitoringResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
