/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code> . Amazon
 * SageMakerhyperparameter tuning captures all defined metrics. You specify one metric that a hyperparameter tuning job
 * uses as its objective metric to choose the best training job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDefinition.Builder, MetricDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricDefinition::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String regex;

    private MetricDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.regex = builder.regex;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A regular expression that searches the output of a training job and gets the value of the metric. For more
     * information about using regular expressions to define metrics, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html">Defining
     * Objective Metrics</a>.
     * </p>
     * 
     * @return A regular expression that searches the output of a training job and gets the value of the metric. For
     *         more information about using regular expressions to define metrics, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html"
     *         >Defining Objective Metrics</a>.
     */
    public String regex() {
        return regex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(regex(), other.regex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricDefinition").add("Name", name()).add("Regex", regex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Regex":
            return Optional.ofNullable(clazz.cast(regex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinition, T> g) {
        return obj -> g.apply((MetricDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDefinition> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param name
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A regular expression that searches the output of a training job and gets the value of the metric. For more
         * information about using regular expressions to define metrics, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html">Defining
         * Objective Metrics</a>.
         * </p>
         * 
         * @param regex
         *        A regular expression that searches the output of a training job and gets the value of the metric. For
         *        more information about using regular expressions to define metrics, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html"
         *        >Defining Objective Metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String regex;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            name(model.name);
            regex(model.regex);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegex() {
            return regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public MetricDefinition build() {
            return new MetricDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
