/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutoMlJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAutoMlJobsResponse> {
    private static final SdkField<List<AutoMLJobSummary>> AUTO_ML_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAutoMlJobsResponse.getter(ListAutoMlJobsResponse::autoMLJobSummaries)).setter(ListAutoMlJobsResponse.setter(Builder::autoMLJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAutoMlJobsResponse.getter(ListAutoMlJobsResponse::nextToken)).setter(ListAutoMlJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutoMLJobSummary> autoMLJobSummaries;
    private final String nextToken;

    private ListAutoMlJobsResponse(BuilderImpl builder) {
        super(builder);
        this.autoMLJobSummaries = builder.autoMLJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<AutoMLJobSummary> autoMLJobSummaries() {
        return this.autoMLJobSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutoMlJobsResponse)) {
            return false;
        }
        ListAutoMlJobsResponse other = (ListAutoMlJobsResponse)((Object)obj);
        return Objects.equals(this.autoMLJobSummaries(), other.autoMLJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAutoMlJobsResponse").add("AutoMLJobSummaries", this.autoMLJobSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAutoMlJobsResponse, T> g) {
        return obj -> g.apply((ListAutoMlJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AutoMLJobSummary> autoMLJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutoMlJobsResponse model) {
            super(model);
            this.autoMLJobSummaries(model.autoMLJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutoMLJobSummary.Builder> getAutoMLJobSummaries() {
            return this.autoMLJobSummaries != null ? (Collection)this.autoMLJobSummaries.stream().map(AutoMLJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoMLJobSummaries(Collection<AutoMLJobSummary> autoMLJobSummaries) {
            this.autoMLJobSummaries = AutoMLJobSummariesCopier.copy(autoMLJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobSummaries(AutoMLJobSummary ... autoMLJobSummaries) {
            this.autoMLJobSummaries(Arrays.asList(autoMLJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobSummaries(Consumer<AutoMLJobSummary.Builder> ... autoMLJobSummaries) {
            this.autoMLJobSummaries(Stream.of(autoMLJobSummaries).map(c -> (AutoMLJobSummary)((AutoMLJobSummary.Builder)AutoMLJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoMLJobSummaries(Collection<AutoMLJobSummary.BuilderImpl> autoMLJobSummaries) {
            this.autoMLJobSummaries = AutoMLJobSummariesCopier.copyFromBuilder(autoMLJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAutoMlJobsResponse build() {
            return new ListAutoMlJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutoMlJobsResponse> {
        public Builder autoMLJobSummaries(Collection<AutoMLJobSummary> var1);

        public Builder autoMLJobSummaries(AutoMLJobSummary ... var1);

        public Builder autoMLJobSummaries(Consumer<AutoMLJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

