/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchStrategy;
import software.amazon.awssdk.services.sagemaker.model.DataProcessing;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TransformEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStatus;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransformJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeTransformJobResponse> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformJobName)).setter(DescribeTransformJobResponse.setter(Builder::transformJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformJobArn)).setter(DescribeTransformJobResponse.setter(Builder::transformJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobArn").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformJobStatusAsString)).setter(DescribeTransformJobResponse.setter(Builder::transformJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::failureReason)).setter(DescribeTransformJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::modelName)).setter(DescribeTransformJobResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::maxConcurrentTransforms)).setter(DescribeTransformJobResponse.setter(Builder::maxConcurrentTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build()}).build();
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::maxPayloadInMB)).setter(DescribeTransformJobResponse.setter(Builder::maxPayloadInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()}).build();
    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::batchStrategyAsString)).setter(DescribeTransformJobResponse.setter(Builder::batchStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::environment)).setter(DescribeTransformJobResponse.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformInput)).setter(DescribeTransformJobResponse.setter(Builder::transformInput)).constructor(TransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()}).build();
    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformOutput)).setter(DescribeTransformJobResponse.setter(Builder::transformOutput)).constructor(TransformOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()}).build();
    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformResources)).setter(DescribeTransformJobResponse.setter(Builder::transformResources)).constructor(TransformResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::creationTime)).setter(DescribeTransformJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRANSFORM_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformStartTime)).setter(DescribeTransformJobResponse.setter(Builder::transformStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformStartTime").build()}).build();
    private static final SdkField<Instant> TRANSFORM_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::transformEndTime)).setter(DescribeTransformJobResponse.setter(Builder::transformEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEndTime").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::labelingJobArn)).setter(DescribeTransformJobResponse.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::autoMLJobArn)).setter(DescribeTransformJobResponse.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<DataProcessing> DATA_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::dataProcessing)).setter(DescribeTransformJobResponse.setter(Builder::dataProcessing)).constructor(DataProcessing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProcessing").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTransformJobResponse.getter(DescribeTransformJobResponse::experimentConfig)).setter(DescribeTransformJobResponse.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD, TRANSFORM_JOB_ARN_FIELD, TRANSFORM_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, MODEL_NAME_FIELD, MAX_CONCURRENT_TRANSFORMS_FIELD, MAX_PAYLOAD_IN_MB_FIELD, BATCH_STRATEGY_FIELD, ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD, CREATION_TIME_FIELD, TRANSFORM_START_TIME_FIELD, TRANSFORM_END_TIME_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, DATA_PROCESSING_FIELD, EXPERIMENT_CONFIG_FIELD));
    private final String transformJobName;
    private final String transformJobArn;
    private final String transformJobStatus;
    private final String failureReason;
    private final String modelName;
    private final Integer maxConcurrentTransforms;
    private final Integer maxPayloadInMB;
    private final String batchStrategy;
    private final Map<String, String> environment;
    private final TransformInput transformInput;
    private final TransformOutput transformOutput;
    private final TransformResources transformResources;
    private final Instant creationTime;
    private final Instant transformStartTime;
    private final Instant transformEndTime;
    private final String labelingJobArn;
    private final String autoMLJobArn;
    private final DataProcessing dataProcessing;
    private final ExperimentConfig experimentConfig;

    private DescribeTransformJobResponse(BuilderImpl builder) {
        super(builder);
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.creationTime = builder.creationTime;
        this.transformStartTime = builder.transformStartTime;
        this.transformEndTime = builder.transformEndTime;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.dataProcessing = builder.dataProcessing;
        this.experimentConfig = builder.experimentConfig;
    }

    public String transformJobName() {
        return this.transformJobName;
    }

    public String transformJobArn() {
        return this.transformJobArn;
    }

    public TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(this.transformJobStatus);
    }

    public String transformJobStatusAsString() {
        return this.transformJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String modelName() {
        return this.modelName;
    }

    public Integer maxConcurrentTransforms() {
        return this.maxConcurrentTransforms;
    }

    public Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(this.batchStrategy);
    }

    public String batchStrategyAsString() {
        return this.batchStrategy;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public TransformInput transformInput() {
        return this.transformInput;
    }

    public TransformOutput transformOutput() {
        return this.transformOutput;
    }

    public TransformResources transformResources() {
        return this.transformResources;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant transformStartTime() {
        return this.transformStartTime;
    }

    public Instant transformEndTime() {
        return this.transformEndTime;
    }

    public String labelingJobArn() {
        return this.labelingJobArn;
    }

    public String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public DataProcessing dataProcessing() {
        return this.dataProcessing;
    }

    public ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransformJobResponse)) {
            return false;
        }
        DescribeTransformJobResponse other = (DescribeTransformJobResponse)((Object)obj);
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.transformJobArn(), other.transformJobArn()) && Objects.equals(this.transformJobStatusAsString(), other.transformJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.maxConcurrentTransforms(), other.maxConcurrentTransforms()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.batchStrategyAsString(), other.batchStrategyAsString()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.transformInput(), other.transformInput()) && Objects.equals(this.transformOutput(), other.transformOutput()) && Objects.equals(this.transformResources(), other.transformResources()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.transformStartTime(), other.transformStartTime()) && Objects.equals(this.transformEndTime(), other.transformEndTime()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.dataProcessing(), other.dataProcessing()) && Objects.equals(this.experimentConfig(), other.experimentConfig());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransformJobResponse").add("TransformJobName", (Object)this.transformJobName()).add("TransformJobArn", (Object)this.transformJobArn()).add("TransformJobStatus", (Object)this.transformJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("ModelName", (Object)this.modelName()).add("MaxConcurrentTransforms", (Object)this.maxConcurrentTransforms()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("BatchStrategy", (Object)this.batchStrategyAsString()).add("Environment", this.environment()).add("TransformInput", (Object)this.transformInput()).add("TransformOutput", (Object)this.transformOutput()).add("TransformResources", (Object)this.transformResources()).add("CreationTime", (Object)this.creationTime()).add("TransformStartTime", (Object)this.transformStartTime()).add("TransformEndTime", (Object)this.transformEndTime()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("DataProcessing", (Object)this.dataProcessing()).add("ExperimentConfig", (Object)this.experimentConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "TransformJobArn": {
                return Optional.ofNullable(clazz.cast(this.transformJobArn()));
            }
            case "TransformJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transformJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "MaxConcurrentTransforms": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTransforms()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "BatchStrategy": {
                return Optional.ofNullable(clazz.cast(this.batchStrategyAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "TransformInput": {
                return Optional.ofNullable(clazz.cast(this.transformInput()));
            }
            case "TransformOutput": {
                return Optional.ofNullable(clazz.cast(this.transformOutput()));
            }
            case "TransformResources": {
                return Optional.ofNullable(clazz.cast(this.transformResources()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TransformStartTime": {
                return Optional.ofNullable(clazz.cast(this.transformStartTime()));
            }
            case "TransformEndTime": {
                return Optional.ofNullable(clazz.cast(this.transformEndTime()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "DataProcessing": {
                return Optional.ofNullable(clazz.cast(this.dataProcessing()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransformJobResponse, T> g) {
        return obj -> g.apply((DescribeTransformJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String transformJobName;
        private String transformJobArn;
        private String transformJobStatus;
        private String failureReason;
        private String modelName;
        private Integer maxConcurrentTransforms;
        private Integer maxPayloadInMB;
        private String batchStrategy;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private TransformInput transformInput;
        private TransformOutput transformOutput;
        private TransformResources transformResources;
        private Instant creationTime;
        private Instant transformStartTime;
        private Instant transformEndTime;
        private String labelingJobArn;
        private String autoMLJobArn;
        private DataProcessing dataProcessing;
        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransformJobResponse model) {
            super(model);
            this.transformJobName(model.transformJobName);
            this.transformJobArn(model.transformJobArn);
            this.transformJobStatus(model.transformJobStatus);
            this.failureReason(model.failureReason);
            this.modelName(model.modelName);
            this.maxConcurrentTransforms(model.maxConcurrentTransforms);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.batchStrategy(model.batchStrategy);
            this.environment(model.environment);
            this.transformInput(model.transformInput);
            this.transformOutput(model.transformOutput);
            this.transformResources(model.transformResources);
            this.creationTime(model.creationTime);
            this.transformStartTime(model.transformStartTime);
            this.transformEndTime(model.transformEndTime);
            this.labelingJobArn(model.labelingJobArn);
            this.autoMLJobArn(model.autoMLJobArn);
            this.dataProcessing(model.dataProcessing);
            this.experimentConfig(model.experimentConfig);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getTransformJobArn() {
            return this.transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        public final String getTransformJobStatusAsString() {
            return this.transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus == null ? null : transformJobStatus.toString());
            return this;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        public final String getBatchStrategyAsString() {
            return this.batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        public final TransformInput.Builder getTransformInput() {
            return this.transformInput != null ? this.transformInput.toBuilder() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return this.transformOutput != null ? this.transformOutput.toBuilder() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        public final TransformResources.Builder getTransformResources() {
            return this.transformResources != null ? this.transformResources.toBuilder() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTransformStartTime() {
            return this.transformStartTime;
        }

        @Override
        public final Builder transformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
            return this;
        }

        public final void setTransformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
        }

        public final Instant getTransformEndTime() {
            return this.transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final DataProcessing.Builder getDataProcessing() {
            return this.dataProcessing != null ? this.dataProcessing.toBuilder() : null;
        }

        @Override
        public final Builder dataProcessing(DataProcessing dataProcessing) {
            this.dataProcessing = dataProcessing;
            return this;
        }

        public final void setDataProcessing(DataProcessing.BuilderImpl dataProcessing) {
            this.dataProcessing = dataProcessing != null ? dataProcessing.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public DescribeTransformJobResponse build() {
            return new DescribeTransformJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransformJobResponse> {
        public Builder transformJobName(String var1);

        public Builder transformJobArn(String var1);

        public Builder transformJobStatus(String var1);

        public Builder transformJobStatus(TransformJobStatus var1);

        public Builder failureReason(String var1);

        public Builder modelName(String var1);

        public Builder maxConcurrentTransforms(Integer var1);

        public Builder maxPayloadInMB(Integer var1);

        public Builder batchStrategy(String var1);

        public Builder batchStrategy(BatchStrategy var1);

        public Builder environment(Map<String, String> var1);

        public Builder transformInput(TransformInput var1);

        default public Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return this.transformInput((TransformInput)((TransformInput.Builder)TransformInput.builder().applyMutation(transformInput)).build());
        }

        public Builder transformOutput(TransformOutput var1);

        default public Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return this.transformOutput((TransformOutput)((TransformOutput.Builder)TransformOutput.builder().applyMutation(transformOutput)).build());
        }

        public Builder transformResources(TransformResources var1);

        default public Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return this.transformResources((TransformResources)((TransformResources.Builder)TransformResources.builder().applyMutation(transformResources)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder transformStartTime(Instant var1);

        public Builder transformEndTime(Instant var1);

        public Builder labelingJobArn(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder dataProcessing(DataProcessing var1);

        default public Builder dataProcessing(Consumer<DataProcessing.Builder> dataProcessing) {
            return this.dataProcessing((DataProcessing)((DataProcessing.Builder)DataProcessing.builder().applyMutation(dataProcessing)).build());
        }

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }
    }
}

