/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.CheckpointConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugHookConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrainingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateTrainingJobRequest> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::trainingJobName)).setter(CreateTrainingJobRequest.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::hyperParameters)).setter(CreateTrainingJobRequest.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::algorithmSpecification)).setter(CreateTrainingJobRequest.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::roleArn)).setter(CreateTrainingJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::inputDataConfig)).setter(CreateTrainingJobRequest.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::outputDataConfig)).setter(CreateTrainingJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::resourceConfig)).setter(CreateTrainingJobRequest.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::vpcConfig)).setter(CreateTrainingJobRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::stoppingCondition)).setter(CreateTrainingJobRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::tags)).setter(CreateTrainingJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::enableNetworkIsolation)).setter(CreateTrainingJobRequest.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::enableInterContainerTrafficEncryption)).setter(CreateTrainingJobRequest.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::enableManagedSpotTraining)).setter(CreateTrainingJobRequest.setter(Builder::enableManagedSpotTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build()}).build();
    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::checkpointConfig)).setter(CreateTrainingJobRequest.setter(Builder::checkpointConfig)).constructor(CheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()}).build();
    private static final SdkField<DebugHookConfig> DEBUG_HOOK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::debugHookConfig)).setter(CreateTrainingJobRequest.setter(Builder::debugHookConfig)).constructor(DebugHookConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugHookConfig").build()}).build();
    private static final SdkField<List<DebugRuleConfiguration>> DEBUG_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::debugRuleConfigurations)).setter(CreateTrainingJobRequest.setter(Builder::debugRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DebugRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TensorBoardOutputConfig> TENSOR_BOARD_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::tensorBoardOutputConfig)).setter(CreateTrainingJobRequest.setter(Builder::tensorBoardOutputConfig)).constructor(TensorBoardOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardOutputConfig").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::experimentConfig)).setter(CreateTrainingJobRequest.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD, CHECKPOINT_CONFIG_FIELD, DEBUG_HOOK_CONFIG_FIELD, DEBUG_RULE_CONFIGURATIONS_FIELD, TENSOR_BOARD_OUTPUT_CONFIG_FIELD, EXPERIMENT_CONFIG_FIELD));
    private final String trainingJobName;
    private final Map<String, String> hyperParameters;
    private final AlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final VpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final List<Tag> tags;
    private final Boolean enableNetworkIsolation;
    private final Boolean enableInterContainerTrafficEncryption;
    private final Boolean enableManagedSpotTraining;
    private final CheckpointConfig checkpointConfig;
    private final DebugHookConfig debugHookConfig;
    private final List<DebugRuleConfiguration> debugRuleConfigurations;
    private final TensorBoardOutputConfig tensorBoardOutputConfig;
    private final ExperimentConfig experimentConfig;

    private CreateTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.debugHookConfig = builder.debugHookConfig;
        this.debugRuleConfigurations = builder.debugRuleConfigurations;
        this.tensorBoardOutputConfig = builder.tensorBoardOutputConfig;
        this.experimentConfig = builder.experimentConfig;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public Boolean enableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public DebugHookConfig debugHookConfig() {
        return this.debugHookConfig;
    }

    public List<DebugRuleConfiguration> debugRuleConfigurations() {
        return this.debugRuleConfigurations;
    }

    public TensorBoardOutputConfig tensorBoardOutputConfig() {
        return this.tensorBoardOutputConfig;
    }

    public ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugHookConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugRuleConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.tensorBoardOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingJobRequest)) {
            return false;
        }
        CreateTrainingJobRequest other = (CreateTrainingJobRequest)((Object)obj);
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.enableManagedSpotTraining(), other.enableManagedSpotTraining()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.debugHookConfig(), other.debugHookConfig()) && Objects.equals(this.debugRuleConfigurations(), other.debugRuleConfigurations()) && Objects.equals(this.tensorBoardOutputConfig(), other.tensorBoardOutputConfig()) && Objects.equals(this.experimentConfig(), other.experimentConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrainingJobRequest").add("TrainingJobName", (Object)this.trainingJobName()).add("HyperParameters", this.hyperParameters()).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.tags()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("EnableManagedSpotTraining", (Object)this.enableManagedSpotTraining()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("DebugHookConfig", (Object)this.debugHookConfig()).add("DebugRuleConfigurations", this.debugRuleConfigurations()).add("TensorBoardOutputConfig", (Object)this.tensorBoardOutputConfig()).add("ExperimentConfig", (Object)this.experimentConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "EnableManagedSpotTraining": {
                return Optional.ofNullable(clazz.cast(this.enableManagedSpotTraining()));
            }
            case "CheckpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "DebugHookConfig": {
                return Optional.ofNullable(clazz.cast(this.debugHookConfig()));
            }
            case "DebugRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.debugRuleConfigurations()));
            }
            case "TensorBoardOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.tensorBoardOutputConfig()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingJobRequest, T> g) {
        return obj -> g.apply((CreateTrainingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trainingJobName;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private AlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private VpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableNetworkIsolation;
        private Boolean enableInterContainerTrafficEncryption;
        private Boolean enableManagedSpotTraining;
        private CheckpointConfig checkpointConfig;
        private DebugHookConfig debugHookConfig;
        private List<DebugRuleConfiguration> debugRuleConfigurations = DefaultSdkAutoConstructList.getInstance();
        private TensorBoardOutputConfig tensorBoardOutputConfig;
        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingJobRequest model) {
            super(model);
            this.trainingJobName(model.trainingJobName);
            this.hyperParameters(model.hyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.enableManagedSpotTraining(model.enableManagedSpotTraining);
            this.checkpointConfig(model.checkpointConfig);
            this.debugHookConfig(model.debugHookConfig);
            this.debugRuleConfigurations(model.debugRuleConfigurations);
            this.tensorBoardOutputConfig(model.tensorBoardOutputConfig);
            this.experimentConfig(model.experimentConfig);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final Map<String, String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return this.enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        public final DebugHookConfig.Builder getDebugHookConfig() {
            return this.debugHookConfig != null ? this.debugHookConfig.toBuilder() : null;
        }

        @Override
        public final Builder debugHookConfig(DebugHookConfig debugHookConfig) {
            this.debugHookConfig = debugHookConfig;
            return this;
        }

        public final void setDebugHookConfig(DebugHookConfig.BuilderImpl debugHookConfig) {
            this.debugHookConfig = debugHookConfig != null ? debugHookConfig.build() : null;
        }

        public final Collection<DebugRuleConfiguration.Builder> getDebugRuleConfigurations() {
            return this.debugRuleConfigurations != null ? (Collection)this.debugRuleConfigurations.stream().map(DebugRuleConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copy(debugRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(DebugRuleConfiguration ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Arrays.asList(debugRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Stream.of(debugRuleConfigurations).map(c -> (DebugRuleConfiguration)((DebugRuleConfiguration.Builder)DebugRuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleConfigurations(Collection<DebugRuleConfiguration.BuilderImpl> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copyFromBuilder(debugRuleConfigurations);
        }

        public final TensorBoardOutputConfig.Builder getTensorBoardOutputConfig() {
            return this.tensorBoardOutputConfig != null ? this.tensorBoardOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig;
            return this;
        }

        public final void setTensorBoardOutputConfig(TensorBoardOutputConfig.BuilderImpl tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig != null ? tensorBoardOutputConfig.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainingJobRequest build() {
            return new CreateTrainingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrainingJobRequest> {
        public Builder trainingJobName(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder enableManagedSpotTraining(Boolean var1);

        public Builder checkpointConfig(CheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((CheckpointConfig)((CheckpointConfig.Builder)CheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder debugHookConfig(DebugHookConfig var1);

        default public Builder debugHookConfig(Consumer<DebugHookConfig.Builder> debugHookConfig) {
            return this.debugHookConfig((DebugHookConfig)((DebugHookConfig.Builder)DebugHookConfig.builder().applyMutation(debugHookConfig)).build());
        }

        public Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> var1);

        public Builder debugRuleConfigurations(DebugRuleConfiguration ... var1);

        public Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... var1);

        public Builder tensorBoardOutputConfig(TensorBoardOutputConfig var1);

        default public Builder tensorBoardOutputConfig(Consumer<TensorBoardOutputConfig.Builder> tensorBoardOutputConfig) {
            return this.tensorBoardOutputConfig((TensorBoardOutputConfig)((TensorBoardOutputConfig.Builder)TensorBoardOutputConfig.builder().applyMutation(tensorBoardOutputConfig)).build());
        }

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

