/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProcessingOutput;
import software.amazon.awssdk.services.sagemaker.model.ProcessingOutputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingOutputConfig> {
    private static final SdkField<List<ProcessingOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProcessingOutputConfig.getter(ProcessingOutputConfig::outputs)).setter(ProcessingOutputConfig.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessingOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingOutputConfig.getter(ProcessingOutputConfig::kmsKeyId)).setter(ProcessingOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUTS_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ProcessingOutput> outputs;
    private final String kmsKeyId;

    private ProcessingOutputConfig(BuilderImpl builder) {
        this.outputs = builder.outputs;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public List<ProcessingOutput> outputs() {
        return this.outputs;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingOutputConfig)) {
            return false;
        }
        ProcessingOutputConfig other = (ProcessingOutputConfig)obj;
        return Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"ProcessingOutputConfig").add("Outputs", this.outputs()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingOutputConfig, T> g) {
        return obj -> g.apply((ProcessingOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProcessingOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingOutputConfig model) {
            this.outputs(model.outputs);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Collection<ProcessingOutput.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(ProcessingOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<ProcessingOutput> outputs) {
            this.outputs = ProcessingOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(ProcessingOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<ProcessingOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (ProcessingOutput)((ProcessingOutput.Builder)ProcessingOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<ProcessingOutput.BuilderImpl> outputs) {
            this.outputs = ProcessingOutputsCopier.copyFromBuilder(outputs);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public ProcessingOutputConfig build() {
            return new ProcessingOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingOutputConfig> {
        public Builder outputs(Collection<ProcessingOutput> var1);

        public Builder outputs(ProcessingOutput ... var1);

        public Builder outputs(Consumer<ProcessingOutput.Builder> ... var1);

        public Builder kmsKeyId(String var1);
    }
}

