/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.BooleanOperator;
import software.amazon.awssdk.services.sagemaker.model.Filter;
import software.amazon.awssdk.services.sagemaker.model.FilterListCopier;
import software.amazon.awssdk.services.sagemaker.model.NestedFilters;
import software.amazon.awssdk.services.sagemaker.model.NestedFiltersListCopier;
import software.amazon.awssdk.services.sagemaker.model.SearchExpressionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchExpression> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchExpression.getter(SearchExpression::filters)).setter(SearchExpression.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NestedFilters>> NESTED_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchExpression.getter(SearchExpression::nestedFilters)).setter(SearchExpression.setter(Builder::nestedFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NestedFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SearchExpression>> SUB_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchExpression.getter(SearchExpression::subExpressions)).setter(SearchExpression.setter(Builder::subExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchExpression.getter(SearchExpression::operatorAsString)).setter(SearchExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, NESTED_FILTERS_FIELD, SUB_EXPRESSIONS_FIELD, OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Filter> filters;
    private final List<NestedFilters> nestedFilters;
    private final List<SearchExpression> subExpressions;
    private final String operator;

    private SearchExpression(BuilderImpl builder) {
        this.filters = builder.filters;
        this.nestedFilters = builder.nestedFilters;
        this.subExpressions = builder.subExpressions;
        this.operator = builder.operator;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<NestedFilters> nestedFilters() {
        return this.nestedFilters;
    }

    public List<SearchExpression> subExpressions() {
        return this.subExpressions;
    }

    public BooleanOperator operator() {
        return BooleanOperator.fromValue(this.operator);
    }

    public String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nestedFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.subExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchExpression)) {
            return false;
        }
        SearchExpression other = (SearchExpression)obj;
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nestedFilters(), other.nestedFilters()) && Objects.equals(this.subExpressions(), other.subExpressions()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public String toString() {
        return ToString.builder((String)"SearchExpression").add("Filters", this.filters()).add("NestedFilters", this.nestedFilters()).add("SubExpressions", this.subExpressions()).add("Operator", (Object)this.operatorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NestedFilters": {
                return Optional.ofNullable(clazz.cast(this.nestedFilters()));
            }
            case "SubExpressions": {
                return Optional.ofNullable(clazz.cast(this.subExpressions()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchExpression, T> g) {
        return obj -> g.apply((SearchExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<NestedFilters> nestedFilters = DefaultSdkAutoConstructList.getInstance();
        private List<SearchExpression> subExpressions = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchExpression model) {
            this.filters(model.filters);
            this.nestedFilters(model.nestedFilters);
            this.subExpressions(model.subExpressions);
            this.operator(model.operator);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<NestedFilters.Builder> getNestedFilters() {
            return this.nestedFilters != null ? (Collection)this.nestedFilters.stream().map(NestedFilters::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nestedFilters(Collection<NestedFilters> nestedFilters) {
            this.nestedFilters = NestedFiltersListCopier.copy(nestedFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedFilters(NestedFilters ... nestedFilters) {
            this.nestedFilters(Arrays.asList(nestedFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedFilters(Consumer<NestedFilters.Builder> ... nestedFilters) {
            this.nestedFilters(Stream.of(nestedFilters).map(c -> (NestedFilters)((NestedFilters.Builder)NestedFilters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNestedFilters(Collection<NestedFilters.BuilderImpl> nestedFilters) {
            this.nestedFilters = NestedFiltersListCopier.copyFromBuilder(nestedFilters);
        }

        public final Collection<Builder> getSubExpressions() {
            return this.subExpressions != null ? (Collection)this.subExpressions.stream().map(SearchExpression::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subExpressions(Collection<SearchExpression> subExpressions) {
            this.subExpressions = SearchExpressionListCopier.copy(subExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subExpressions(SearchExpression ... subExpressions) {
            this.subExpressions(Arrays.asList(subExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subExpressions(Consumer<Builder> ... subExpressions) {
            this.subExpressions(Stream.of(subExpressions).map(c -> (SearchExpression)((Builder)SearchExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubExpressions(Collection<BuilderImpl> subExpressions) {
            this.subExpressions = SearchExpressionListCopier.copyFromBuilder(subExpressions);
        }

        public final String getOperatorAsString() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(BooleanOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public SearchExpression build() {
            return new SearchExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchExpression> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nestedFilters(Collection<NestedFilters> var1);

        public Builder nestedFilters(NestedFilters ... var1);

        public Builder nestedFilters(Consumer<NestedFilters.Builder> ... var1);

        public Builder subExpressions(Collection<SearchExpression> var1);

        public Builder subExpressions(SearchExpression ... var1);

        public Builder subExpressions(Consumer<Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(BooleanOperator var1);
    }
}

