/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerDefinition.getter(ContainerDefinition::containerHostname)).setter(ContainerDefinition.setter(Builder::containerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerDefinition.getter(ContainerDefinition::image)).setter(ContainerDefinition.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerDefinition.getter(ContainerDefinition::modelDataUrl)).setter(ContainerDefinition.setter(Builder::modelDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ContainerDefinition.getter(ContainerDefinition::environment)).setter(ContainerDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerDefinition.getter(ContainerDefinition::modelPackageName)).setter(ContainerDefinition.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD, IMAGE_FIELD, MODEL_DATA_URL_FIELD, ENVIRONMENT_FIELD, MODEL_PACKAGE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerHostname;
    private final String image;
    private final String modelDataUrl;
    private final Map<String, String> environment;
    private final String modelPackageName;

    private ContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.modelDataUrl = builder.modelDataUrl;
        this.environment = builder.environment;
        this.modelPackageName = builder.modelPackageName;
    }

    public String containerHostname() {
        return this.containerHostname;
    }

    public String image() {
        return this.image;
    }

    public String modelDataUrl() {
        return this.modelDataUrl;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public String modelPackageName() {
        return this.modelPackageName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        return Objects.equals(this.containerHostname(), other.containerHostname()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.modelPackageName(), other.modelPackageName());
    }

    public String toString() {
        return ToString.builder((String)"ContainerDefinition").add("ContainerHostname", (Object)this.containerHostname()).add("Image", (Object)this.image()).add("ModelDataUrl", (Object)this.modelDataUrl()).add("Environment", this.environment()).add("ModelPackageName", (Object)this.modelPackageName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerHostname": {
                return Optional.ofNullable(clazz.cast(this.containerHostname()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ModelDataUrl": {
                return Optional.ofNullable(clazz.cast(this.modelDataUrl()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinition, T> g) {
        return obj -> g.apply((ContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerHostname;
        private String image;
        private String modelDataUrl;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private String modelPackageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            this.containerHostname(model.containerHostname);
            this.image(model.image);
            this.modelDataUrl(model.modelDataUrl);
            this.environment(model.environment);
            this.modelPackageName(model.modelPackageName);
        }

        public final String getContainerHostname() {
            return this.containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDefinition> {
        public Builder containerHostname(String var1);

        public Builder image(String var1);

        public Builder modelDataUrl(String var1);

        public Builder environment(Map<String, String> var1);

        public Builder modelPackageName(String var1);
    }
}

