/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;

public class ListHyperParameterTuningJobsIterable
implements SdkIterable<ListHyperParameterTuningJobsResponse> {
    private final SageMakerClient client;
    private final ListHyperParameterTuningJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHyperParameterTuningJobsIterable(SageMakerClient client, ListHyperParameterTuningJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHyperParameterTuningJobsResponseFetcher();
    }

    public Iterator<ListHyperParameterTuningJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListHyperParameterTuningJobsIterable resume(ListHyperParameterTuningJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHyperParameterTuningJobsIterable(this.client, (ListHyperParameterTuningJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHyperParameterTuningJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListHyperParameterTuningJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListHyperParameterTuningJobsResponseFetcher
    implements SyncPageFetcher<ListHyperParameterTuningJobsResponse> {
        private ListHyperParameterTuningJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHyperParameterTuningJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHyperParameterTuningJobsResponse nextPage(ListHyperParameterTuningJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHyperParameterTuningJobsIterable.this.client.listHyperParameterTuningJobs(ListHyperParameterTuningJobsIterable.this.firstRequest);
            }
            return ListHyperParameterTuningJobsIterable.this.client.listHyperParameterTuningJobs((ListHyperParameterTuningJobsRequest)((Object)ListHyperParameterTuningJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

