/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3outposts.model.EndpointAccessType;
import software.amazon.awssdk.services.s3outposts.model.S3OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEndpointRequest
extends S3OutpostsRequest
implements ToCopyableBuilder<Builder, CreateEndpointRequest> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(CreateEndpointRequest.getter(CreateEndpointRequest::outpostId)).setter(CreateEndpointRequest.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateEndpointRequest.getter(CreateEndpointRequest::subnetId)).setter(CreateEndpointRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupId").getter(CreateEndpointRequest.getter(CreateEndpointRequest::securityGroupId)).setter(CreateEndpointRequest.setter(Builder::securityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(CreateEndpointRequest.getter(CreateEndpointRequest::accessTypeAsString)).setter(CreateEndpointRequest.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(CreateEndpointRequest.getter(CreateEndpointRequest::customerOwnedIpv4Pool)).setter(CreateEndpointRequest.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_ID_FIELD, ACCESS_TYPE_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEndpointRequest.memberNameToFieldInitializer();
    private final String outpostId;
    private final String subnetId;
    private final String securityGroupId;
    private final String accessType;
    private final String customerOwnedIpv4Pool;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.outpostId = builder.outpostId;
        this.subnetId = builder.subnetId;
        this.securityGroupId = builder.securityGroupId;
        this.accessType = builder.accessType;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String securityGroupId() {
        return this.securityGroupId;
    }

    public final EndpointAccessType accessType() {
        return EndpointAccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest)((Object)obj);
        return Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.securityGroupId(), other.securityGroupId()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEndpointRequest").add("OutpostId", (Object)this.outpostId()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroupId", (Object)this.securityGroupId()).add("AccessType", (Object)this.accessTypeAsString()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.securityGroupId()));
            }
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_ID_FIELD);
        map.put("AccessType", ACCESS_TYPE_FIELD);
        map.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostId;
        private String subnetId;
        private String securityGroupId;
        private String accessType;
        private String customerOwnedIpv4Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            this.outpostId(model.outpostId);
            this.subnetId(model.subnetId);
            this.securityGroupId(model.securityGroupId);
            this.accessType(model.accessType);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(EndpointAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEndpointRequest> {
        public Builder outpostId(String var1);

        public Builder subnetId(String var1);

        public Builder securityGroupId(String var1);

        public Builder accessType(String var1);

        public Builder accessType(EndpointAccessType var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

