/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3outposts.model.Outpost;
import software.amazon.awssdk.services.s3outposts.model.OutpostsCopier;
import software.amazon.awssdk.services.s3outposts.model.S3OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOutpostsWithS3Response
extends S3OutpostsResponse
implements ToCopyableBuilder<Builder, ListOutpostsWithS3Response> {
    private static final SdkField<List<Outpost>> OUTPOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outposts").getter(ListOutpostsWithS3Response.getter(ListOutpostsWithS3Response::outposts)).setter(ListOutpostsWithS3Response.setter(Builder::outposts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outposts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Outpost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOutpostsWithS3Response.getter(ListOutpostsWithS3Response::nextToken)).setter(ListOutpostsWithS3Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOSTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Outpost> outposts;
    private final String nextToken;

    private ListOutpostsWithS3Response(BuilderImpl builder) {
        super(builder);
        this.outposts = builder.outposts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOutposts() {
        return this.outposts != null && !(this.outposts instanceof SdkAutoConstructList);
    }

    public final List<Outpost> outposts() {
        return this.outposts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutposts() ? this.outposts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostsWithS3Response)) {
            return false;
        }
        ListOutpostsWithS3Response other = (ListOutpostsWithS3Response)((Object)obj);
        return this.hasOutposts() == other.hasOutposts() && Objects.equals(this.outposts(), other.outposts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOutpostsWithS3Response").add("Outposts", this.hasOutposts() ? this.outposts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Outposts": {
                return Optional.ofNullable(clazz.cast(this.outposts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostsWithS3Response, T> g) {
        return obj -> g.apply((ListOutpostsWithS3Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3OutpostsResponse.BuilderImpl
    implements Builder {
        private List<Outpost> outposts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostsWithS3Response model) {
            super(model);
            this.outposts(model.outposts);
            this.nextToken(model.nextToken);
        }

        public final List<Outpost.Builder> getOutposts() {
            List<Outpost.Builder> result = OutpostsCopier.copyToBuilder(this.outposts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutposts(Collection<Outpost.BuilderImpl> outposts) {
            this.outposts = OutpostsCopier.copyFromBuilder(outposts);
        }

        @Override
        public final Builder outposts(Collection<Outpost> outposts) {
            this.outposts = OutpostsCopier.copy(outposts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outposts(Outpost ... outposts) {
            this.outposts(Arrays.asList(outposts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outposts(Consumer<Outpost.Builder> ... outposts) {
            this.outposts(Stream.of(outposts).map(c -> (Outpost)((Outpost.Builder)Outpost.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOutpostsWithS3Response build() {
            return new ListOutpostsWithS3Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOutpostsWithS3Response> {
        public Builder outposts(Collection<Outpost> var1);

        public Builder outposts(Outpost ... var1);

        public Builder outposts(Consumer<Outpost.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

