/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3outposts.S3OutpostsClient;
import software.amazon.awssdk.services.s3outposts.model.ListOutpostsWithS3Request;
import software.amazon.awssdk.services.s3outposts.model.ListOutpostsWithS3Response;
import software.amazon.awssdk.services.s3outposts.model.Outpost;

public class ListOutpostsWithS3Iterable
implements SdkIterable<ListOutpostsWithS3Response> {
    private final S3OutpostsClient client;
    private final ListOutpostsWithS3Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOutpostsWithS3Iterable(S3OutpostsClient client, ListOutpostsWithS3Request firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOutpostsWithS3ResponseFetcher();
    }

    public Iterator<ListOutpostsWithS3Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Outpost> outposts() {
        Function<ListOutpostsWithS3Response, Iterator> getIterator = response -> {
            if (response != null && response.outposts() != null) {
                return response.outposts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOutpostsWithS3ResponseFetcher
    implements SyncPageFetcher<ListOutpostsWithS3Response> {
        private ListOutpostsWithS3ResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostsWithS3Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOutpostsWithS3Response nextPage(ListOutpostsWithS3Response previousPage) {
            if (previousPage == null) {
                return ListOutpostsWithS3Iterable.this.client.listOutpostsWithS3(ListOutpostsWithS3Iterable.this.firstRequest);
            }
            return ListOutpostsWithS3Iterable.this.client.listOutpostsWithS3((ListOutpostsWithS3Request)((Object)ListOutpostsWithS3Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

