/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndpointAccessType {
    PRIVATE("Private"),
    CUSTOMER_OWNED_IP("CustomerOwnedIp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndpointAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndpointAccessType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointAccessType> knownValues() {
        return Stream.of(EndpointAccessType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

