/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectionCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectionCriteria> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(SelectionCriteria.getter(SelectionCriteria::delimiter)).setter(SelectionCriteria.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").unmarshallLocationName("Delimiter").build()}).build();
    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDepth").getter(SelectionCriteria.getter(SelectionCriteria::maxDepth)).setter(SelectionCriteria.setter(Builder::maxDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDepth").unmarshallLocationName("MaxDepth").build()}).build();
    private static final SdkField<Double> MIN_STORAGE_BYTES_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinStorageBytesPercentage").getter(SelectionCriteria.getter(SelectionCriteria::minStorageBytesPercentage)).setter(SelectionCriteria.setter(Builder::minStorageBytesPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageBytesPercentage").unmarshallLocationName("MinStorageBytesPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD, MAX_DEPTH_FIELD, MIN_STORAGE_BYTES_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SelectionCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String delimiter;
    private final Integer maxDepth;
    private final Double minStorageBytesPercentage;

    private SelectionCriteria(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.maxDepth = builder.maxDepth;
        this.minStorageBytesPercentage = builder.minStorageBytesPercentage;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final Integer maxDepth() {
        return this.maxDepth;
    }

    public final Double minStorageBytesPercentage() {
        return this.minStorageBytesPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageBytesPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionCriteria)) {
            return false;
        }
        SelectionCriteria other = (SelectionCriteria)obj;
        return Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.maxDepth(), other.maxDepth()) && Objects.equals(this.minStorageBytesPercentage(), other.minStorageBytesPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"SelectionCriteria").add("Delimiter", (Object)this.delimiter()).add("MaxDepth", (Object)this.maxDepth()).add("MinStorageBytesPercentage", (Object)this.minStorageBytesPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "MaxDepth": {
                return Optional.ofNullable(clazz.cast(this.maxDepth()));
            }
            case "MinStorageBytesPercentage": {
                return Optional.ofNullable(clazz.cast(this.minStorageBytesPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Delimiter", DELIMITER_FIELD);
        map.put("MaxDepth", MAX_DEPTH_FIELD);
        map.put("MinStorageBytesPercentage", MIN_STORAGE_BYTES_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectionCriteria, T> g) {
        return obj -> g.apply((SelectionCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String delimiter;
        private Integer maxDepth;
        private Double minStorageBytesPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectionCriteria model) {
            this.delimiter(model.delimiter);
            this.maxDepth(model.maxDepth);
            this.minStorageBytesPercentage(model.minStorageBytesPercentage);
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Integer getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final Double getMinStorageBytesPercentage() {
            return this.minStorageBytesPercentage;
        }

        public final void setMinStorageBytesPercentage(Double minStorageBytesPercentage) {
            this.minStorageBytesPercentage = minStorageBytesPercentage;
        }

        @Override
        public final Builder minStorageBytesPercentage(Double minStorageBytesPercentage) {
            this.minStorageBytesPercentage = minStorageBytesPercentage;
            return this;
        }

        public SelectionCriteria build() {
            return new SelectionCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectionCriteria> {
        public Builder delimiter(String var1);

        public Builder maxDepth(Integer var1);

        public Builder minStorageBytesPercentage(Double var1);
    }
}

