/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList;
import software.amazon.awssdk.services.s3control.model.S3ChecksumAlgorithm;
import software.amazon.awssdk.services.s3control.model.S3Grant;
import software.amazon.awssdk.services.s3control.model.S3GrantListCopier;
import software.amazon.awssdk.services.s3control.model.S3MetadataDirective;
import software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3control.model.S3ObjectLockMode;
import software.amazon.awssdk.services.s3control.model.S3ObjectMetadata;
import software.amazon.awssdk.services.s3control.model.S3StorageClass;
import software.amazon.awssdk.services.s3control.model.S3Tag;
import software.amazon.awssdk.services.s3control.model.S3TagSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3CopyObjectOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3CopyObjectOperation> {
    private static final SdkField<String> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetResource").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::targetResource)).setter(S3CopyObjectOperation.setter(Builder::targetResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResource").unmarshallLocationName("TargetResource").build()}).build();
    private static final SdkField<String> CANNED_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CannedAccessControlList").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::cannedAccessControlListAsString)).setter(S3CopyObjectOperation.setter(Builder::cannedAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAccessControlList").unmarshallLocationName("CannedAccessControlList").build()}).build();
    private static final SdkField<List<S3Grant>> ACCESS_CONTROL_GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlGrants").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::accessControlGrants)).setter(S3CopyObjectOperation.setter(Builder::accessControlGrants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlGrants").unmarshallLocationName("AccessControlGrants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Grant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METADATA_DIRECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataDirective").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::metadataDirectiveAsString)).setter(S3CopyObjectOperation.setter(Builder::metadataDirective)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataDirective").unmarshallLocationName("MetadataDirective").build()}).build();
    private static final SdkField<Instant> MODIFIED_SINCE_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedSinceConstraint").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::modifiedSinceConstraint)).setter(S3CopyObjectOperation.setter(Builder::modifiedSinceConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedSinceConstraint").unmarshallLocationName("ModifiedSinceConstraint").build()}).build();
    private static final SdkField<S3ObjectMetadata> NEW_OBJECT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewObjectMetadata").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::newObjectMetadata)).setter(S3CopyObjectOperation.setter(Builder::newObjectMetadata)).constructor(S3ObjectMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewObjectMetadata").unmarshallLocationName("NewObjectMetadata").build()}).build();
    private static final SdkField<List<S3Tag>> NEW_OBJECT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewObjectTagging").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::newObjectTagging)).setter(S3CopyObjectOperation.setter(Builder::newObjectTagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewObjectTagging").unmarshallLocationName("NewObjectTagging").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectLocation").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::redirectLocation)).setter(S3CopyObjectOperation.setter(Builder::redirectLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectLocation").unmarshallLocationName("RedirectLocation").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPays").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::requesterPays)).setter(S3CopyObjectOperation.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").unmarshallLocationName("RequesterPays").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageClass").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::storageClassAsString)).setter(S3CopyObjectOperation.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").unmarshallLocationName("StorageClass").build()}).build();
    private static final SdkField<Instant> UN_MODIFIED_SINCE_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UnModifiedSinceConstraint").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::unModifiedSinceConstraint)).setter(S3CopyObjectOperation.setter(Builder::unModifiedSinceConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnModifiedSinceConstraint").unmarshallLocationName("UnModifiedSinceConstraint").build()}).build();
    private static final SdkField<String> SSE_AWS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSEAwsKmsKeyId").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::sseAwsKmsKeyId)).setter(S3CopyObjectOperation.setter(Builder::sseAwsKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAwsKmsKeyId").unmarshallLocationName("SSEAwsKmsKeyId").build()}).build();
    private static final SdkField<String> TARGET_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKeyPrefix").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::targetKeyPrefix)).setter(S3CopyObjectOperation.setter(Builder::targetKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetKeyPrefix").unmarshallLocationName("TargetKeyPrefix").build()}).build();
    private static final SdkField<String> OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectLockLegalHoldStatus").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockLegalHoldStatusAsString)).setter(S3CopyObjectOperation.setter(Builder::objectLockLegalHoldStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockLegalHoldStatus").unmarshallLocationName("ObjectLockLegalHoldStatus").build()}).build();
    private static final SdkField<String> OBJECT_LOCK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectLockMode").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockModeAsString)).setter(S3CopyObjectOperation.setter(Builder::objectLockMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockMode").unmarshallLocationName("ObjectLockMode").build()}).build();
    private static final SdkField<Instant> OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ObjectLockRetainUntilDate").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockRetainUntilDate)).setter(S3CopyObjectOperation.setter(Builder::objectLockRetainUntilDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockRetainUntilDate").unmarshallLocationName("ObjectLockRetainUntilDate").build()}).build();
    private static final SdkField<Boolean> BUCKET_KEY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BucketKeyEnabled").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::bucketKeyEnabled)).setter(S3CopyObjectOperation.setter(Builder::bucketKeyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketKeyEnabled").unmarshallLocationName("BucketKeyEnabled").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::checksumAlgorithmAsString)).setter(S3CopyObjectOperation.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChecksumAlgorithm").unmarshallLocationName("ChecksumAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_FIELD, CANNED_ACCESS_CONTROL_LIST_FIELD, ACCESS_CONTROL_GRANTS_FIELD, METADATA_DIRECTIVE_FIELD, MODIFIED_SINCE_CONSTRAINT_FIELD, NEW_OBJECT_METADATA_FIELD, NEW_OBJECT_TAGGING_FIELD, REDIRECT_LOCATION_FIELD, REQUESTER_PAYS_FIELD, STORAGE_CLASS_FIELD, UN_MODIFIED_SINCE_CONSTRAINT_FIELD, SSE_AWS_KMS_KEY_ID_FIELD, TARGET_KEY_PREFIX_FIELD, OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD, OBJECT_LOCK_MODE_FIELD, OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD, BUCKET_KEY_ENABLED_FIELD, CHECKSUM_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3CopyObjectOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetResource;
    private final String cannedAccessControlList;
    private final List<S3Grant> accessControlGrants;
    private final String metadataDirective;
    private final Instant modifiedSinceConstraint;
    private final S3ObjectMetadata newObjectMetadata;
    private final List<S3Tag> newObjectTagging;
    private final String redirectLocation;
    private final Boolean requesterPays;
    private final String storageClass;
    private final Instant unModifiedSinceConstraint;
    private final String sseAwsKmsKeyId;
    private final String targetKeyPrefix;
    private final String objectLockLegalHoldStatus;
    private final String objectLockMode;
    private final Instant objectLockRetainUntilDate;
    private final Boolean bucketKeyEnabled;
    private final String checksumAlgorithm;

    private S3CopyObjectOperation(BuilderImpl builder) {
        this.targetResource = builder.targetResource;
        this.cannedAccessControlList = builder.cannedAccessControlList;
        this.accessControlGrants = builder.accessControlGrants;
        this.metadataDirective = builder.metadataDirective;
        this.modifiedSinceConstraint = builder.modifiedSinceConstraint;
        this.newObjectMetadata = builder.newObjectMetadata;
        this.newObjectTagging = builder.newObjectTagging;
        this.redirectLocation = builder.redirectLocation;
        this.requesterPays = builder.requesterPays;
        this.storageClass = builder.storageClass;
        this.unModifiedSinceConstraint = builder.unModifiedSinceConstraint;
        this.sseAwsKmsKeyId = builder.sseAwsKmsKeyId;
        this.targetKeyPrefix = builder.targetKeyPrefix;
        this.objectLockLegalHoldStatus = builder.objectLockLegalHoldStatus;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
        this.bucketKeyEnabled = builder.bucketKeyEnabled;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    public final String targetResource() {
        return this.targetResource;
    }

    public final S3CannedAccessControlList cannedAccessControlList() {
        return S3CannedAccessControlList.fromValue(this.cannedAccessControlList);
    }

    public final String cannedAccessControlListAsString() {
        return this.cannedAccessControlList;
    }

    public final boolean hasAccessControlGrants() {
        return this.accessControlGrants != null && !(this.accessControlGrants instanceof SdkAutoConstructList);
    }

    public final List<S3Grant> accessControlGrants() {
        return this.accessControlGrants;
    }

    public final S3MetadataDirective metadataDirective() {
        return S3MetadataDirective.fromValue(this.metadataDirective);
    }

    public final String metadataDirectiveAsString() {
        return this.metadataDirective;
    }

    public final Instant modifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public final S3ObjectMetadata newObjectMetadata() {
        return this.newObjectMetadata;
    }

    public final boolean hasNewObjectTagging() {
        return this.newObjectTagging != null && !(this.newObjectTagging instanceof SdkAutoConstructList);
    }

    public final List<S3Tag> newObjectTagging() {
        return this.newObjectTagging;
    }

    public final String redirectLocation() {
        return this.redirectLocation;
    }

    public final Boolean requesterPays() {
        return this.requesterPays;
    }

    public final S3StorageClass storageClass() {
        return S3StorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public final Instant unModifiedSinceConstraint() {
        return this.unModifiedSinceConstraint;
    }

    public final String sseAwsKmsKeyId() {
        return this.sseAwsKmsKeyId;
    }

    public final String targetKeyPrefix() {
        return this.targetKeyPrefix;
    }

    public final S3ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
        return S3ObjectLockLegalHoldStatus.fromValue(this.objectLockLegalHoldStatus);
    }

    public final String objectLockLegalHoldStatusAsString() {
        return this.objectLockLegalHoldStatus;
    }

    public final S3ObjectLockMode objectLockMode() {
        return S3ObjectLockMode.fromValue(this.objectLockMode);
    }

    public final String objectLockModeAsString() {
        return this.objectLockMode;
    }

    public final Instant objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public final Boolean bucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public final S3ChecksumAlgorithm checksumAlgorithm() {
        return S3ChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAccessControlListAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlGrants() ? this.accessControlGrants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataDirectiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedSinceConstraint());
        hashCode = 31 * hashCode + Objects.hashCode(this.newObjectMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewObjectTagging() ? this.newObjectTagging() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unModifiedSinceConstraint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAwsKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockLegalHoldStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockRetainUntilDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketKeyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CopyObjectOperation)) {
            return false;
        }
        S3CopyObjectOperation other = (S3CopyObjectOperation)obj;
        return Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.cannedAccessControlListAsString(), other.cannedAccessControlListAsString()) && this.hasAccessControlGrants() == other.hasAccessControlGrants() && Objects.equals(this.accessControlGrants(), other.accessControlGrants()) && Objects.equals(this.metadataDirectiveAsString(), other.metadataDirectiveAsString()) && Objects.equals(this.modifiedSinceConstraint(), other.modifiedSinceConstraint()) && Objects.equals(this.newObjectMetadata(), other.newObjectMetadata()) && this.hasNewObjectTagging() == other.hasNewObjectTagging() && Objects.equals(this.newObjectTagging(), other.newObjectTagging()) && Objects.equals(this.redirectLocation(), other.redirectLocation()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.unModifiedSinceConstraint(), other.unModifiedSinceConstraint()) && Objects.equals(this.sseAwsKmsKeyId(), other.sseAwsKmsKeyId()) && Objects.equals(this.targetKeyPrefix(), other.targetKeyPrefix()) && Objects.equals(this.objectLockLegalHoldStatusAsString(), other.objectLockLegalHoldStatusAsString()) && Objects.equals(this.objectLockModeAsString(), other.objectLockModeAsString()) && Objects.equals(this.objectLockRetainUntilDate(), other.objectLockRetainUntilDate()) && Objects.equals(this.bucketKeyEnabled(), other.bucketKeyEnabled()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3CopyObjectOperation").add("TargetResource", (Object)this.targetResource()).add("CannedAccessControlList", (Object)this.cannedAccessControlListAsString()).add("AccessControlGrants", this.hasAccessControlGrants() ? this.accessControlGrants() : null).add("MetadataDirective", (Object)this.metadataDirectiveAsString()).add("ModifiedSinceConstraint", (Object)this.modifiedSinceConstraint()).add("NewObjectMetadata", (Object)this.newObjectMetadata()).add("NewObjectTagging", this.hasNewObjectTagging() ? this.newObjectTagging() : null).add("RedirectLocation", (Object)this.redirectLocation()).add("RequesterPays", (Object)this.requesterPays()).add("StorageClass", (Object)this.storageClassAsString()).add("UnModifiedSinceConstraint", (Object)this.unModifiedSinceConstraint()).add("SSEAwsKmsKeyId", (Object)this.sseAwsKmsKeyId()).add("TargetKeyPrefix", (Object)this.targetKeyPrefix()).add("ObjectLockLegalHoldStatus", (Object)this.objectLockLegalHoldStatusAsString()).add("ObjectLockMode", (Object)this.objectLockModeAsString()).add("ObjectLockRetainUntilDate", (Object)this.objectLockRetainUntilDate()).add("BucketKeyEnabled", (Object)this.bucketKeyEnabled()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "CannedAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.cannedAccessControlListAsString()));
            }
            case "AccessControlGrants": {
                return Optional.ofNullable(clazz.cast(this.accessControlGrants()));
            }
            case "MetadataDirective": {
                return Optional.ofNullable(clazz.cast(this.metadataDirectiveAsString()));
            }
            case "ModifiedSinceConstraint": {
                return Optional.ofNullable(clazz.cast(this.modifiedSinceConstraint()));
            }
            case "NewObjectMetadata": {
                return Optional.ofNullable(clazz.cast(this.newObjectMetadata()));
            }
            case "NewObjectTagging": {
                return Optional.ofNullable(clazz.cast(this.newObjectTagging()));
            }
            case "RedirectLocation": {
                return Optional.ofNullable(clazz.cast(this.redirectLocation()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "UnModifiedSinceConstraint": {
                return Optional.ofNullable(clazz.cast(this.unModifiedSinceConstraint()));
            }
            case "SSEAwsKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseAwsKmsKeyId()));
            }
            case "TargetKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.targetKeyPrefix()));
            }
            case "ObjectLockLegalHoldStatus": {
                return Optional.ofNullable(clazz.cast(this.objectLockLegalHoldStatusAsString()));
            }
            case "ObjectLockMode": {
                return Optional.ofNullable(clazz.cast(this.objectLockModeAsString()));
            }
            case "ObjectLockRetainUntilDate": {
                return Optional.ofNullable(clazz.cast(this.objectLockRetainUntilDate()));
            }
            case "BucketKeyEnabled": {
                return Optional.ofNullable(clazz.cast(this.bucketKeyEnabled()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetResource", TARGET_RESOURCE_FIELD);
        map.put("CannedAccessControlList", CANNED_ACCESS_CONTROL_LIST_FIELD);
        map.put("AccessControlGrants", ACCESS_CONTROL_GRANTS_FIELD);
        map.put("MetadataDirective", METADATA_DIRECTIVE_FIELD);
        map.put("ModifiedSinceConstraint", MODIFIED_SINCE_CONSTRAINT_FIELD);
        map.put("NewObjectMetadata", NEW_OBJECT_METADATA_FIELD);
        map.put("NewObjectTagging", NEW_OBJECT_TAGGING_FIELD);
        map.put("RedirectLocation", REDIRECT_LOCATION_FIELD);
        map.put("RequesterPays", REQUESTER_PAYS_FIELD);
        map.put("StorageClass", STORAGE_CLASS_FIELD);
        map.put("UnModifiedSinceConstraint", UN_MODIFIED_SINCE_CONSTRAINT_FIELD);
        map.put("SSEAwsKmsKeyId", SSE_AWS_KMS_KEY_ID_FIELD);
        map.put("TargetKeyPrefix", TARGET_KEY_PREFIX_FIELD);
        map.put("ObjectLockLegalHoldStatus", OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD);
        map.put("ObjectLockMode", OBJECT_LOCK_MODE_FIELD);
        map.put("ObjectLockRetainUntilDate", OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD);
        map.put("BucketKeyEnabled", BUCKET_KEY_ENABLED_FIELD);
        map.put("ChecksumAlgorithm", CHECKSUM_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3CopyObjectOperation, T> g) {
        return obj -> g.apply((S3CopyObjectOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetResource;
        private String cannedAccessControlList;
        private List<S3Grant> accessControlGrants = DefaultSdkAutoConstructList.getInstance();
        private String metadataDirective;
        private Instant modifiedSinceConstraint;
        private S3ObjectMetadata newObjectMetadata;
        private List<S3Tag> newObjectTagging = DefaultSdkAutoConstructList.getInstance();
        private String redirectLocation;
        private Boolean requesterPays;
        private String storageClass;
        private Instant unModifiedSinceConstraint;
        private String sseAwsKmsKeyId;
        private String targetKeyPrefix;
        private String objectLockLegalHoldStatus;
        private String objectLockMode;
        private Instant objectLockRetainUntilDate;
        private Boolean bucketKeyEnabled;
        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(S3CopyObjectOperation model) {
            this.targetResource(model.targetResource);
            this.cannedAccessControlList(model.cannedAccessControlList);
            this.accessControlGrants(model.accessControlGrants);
            this.metadataDirective(model.metadataDirective);
            this.modifiedSinceConstraint(model.modifiedSinceConstraint);
            this.newObjectMetadata(model.newObjectMetadata);
            this.newObjectTagging(model.newObjectTagging);
            this.redirectLocation(model.redirectLocation);
            this.requesterPays(model.requesterPays);
            this.storageClass(model.storageClass);
            this.unModifiedSinceConstraint(model.unModifiedSinceConstraint);
            this.sseAwsKmsKeyId(model.sseAwsKmsKeyId);
            this.targetKeyPrefix(model.targetKeyPrefix);
            this.objectLockLegalHoldStatus(model.objectLockLegalHoldStatus);
            this.objectLockMode(model.objectLockMode);
            this.objectLockRetainUntilDate(model.objectLockRetainUntilDate);
            this.bucketKeyEnabled(model.bucketKeyEnabled);
            this.checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getTargetResource() {
            return this.targetResource;
        }

        public final void setTargetResource(String targetResource) {
            this.targetResource = targetResource;
        }

        @Override
        public final Builder targetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getCannedAccessControlList() {
            return this.cannedAccessControlList;
        }

        public final void setCannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
        }

        @Override
        public final Builder cannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
            return this;
        }

        @Override
        public final Builder cannedAccessControlList(S3CannedAccessControlList cannedAccessControlList) {
            this.cannedAccessControlList(cannedAccessControlList == null ? null : cannedAccessControlList.toString());
            return this;
        }

        public final List<S3Grant.Builder> getAccessControlGrants() {
            List<S3Grant.Builder> result = S3GrantListCopier.copyToBuilder(this.accessControlGrants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlGrants(Collection<S3Grant.BuilderImpl> accessControlGrants) {
            this.accessControlGrants = S3GrantListCopier.copyFromBuilder(accessControlGrants);
        }

        @Override
        public final Builder accessControlGrants(Collection<S3Grant> accessControlGrants) {
            this.accessControlGrants = S3GrantListCopier.copy(accessControlGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlGrants(S3Grant ... accessControlGrants) {
            this.accessControlGrants(Arrays.asList(accessControlGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlGrants(Consumer<S3Grant.Builder> ... accessControlGrants) {
            this.accessControlGrants(Stream.of(accessControlGrants).map(c -> (S3Grant)((S3Grant.Builder)S3Grant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetadataDirective() {
            return this.metadataDirective;
        }

        public final void setMetadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
        }

        @Override
        public final Builder metadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        @Override
        public final Builder metadataDirective(S3MetadataDirective metadataDirective) {
            this.metadataDirective(metadataDirective == null ? null : metadataDirective.toString());
            return this;
        }

        public final Instant getModifiedSinceConstraint() {
            return this.modifiedSinceConstraint;
        }

        public final void setModifiedSinceConstraint(Instant modifiedSinceConstraint) {
            this.modifiedSinceConstraint = modifiedSinceConstraint;
        }

        @Override
        public final Builder modifiedSinceConstraint(Instant modifiedSinceConstraint) {
            this.modifiedSinceConstraint = modifiedSinceConstraint;
            return this;
        }

        public final S3ObjectMetadata.Builder getNewObjectMetadata() {
            return this.newObjectMetadata != null ? this.newObjectMetadata.toBuilder() : null;
        }

        public final void setNewObjectMetadata(S3ObjectMetadata.BuilderImpl newObjectMetadata) {
            this.newObjectMetadata = newObjectMetadata != null ? newObjectMetadata.build() : null;
        }

        @Override
        public final Builder newObjectMetadata(S3ObjectMetadata newObjectMetadata) {
            this.newObjectMetadata = newObjectMetadata;
            return this;
        }

        public final List<S3Tag.Builder> getNewObjectTagging() {
            List<S3Tag.Builder> result = S3TagSetCopier.copyToBuilder(this.newObjectTagging);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNewObjectTagging(Collection<S3Tag.BuilderImpl> newObjectTagging) {
            this.newObjectTagging = S3TagSetCopier.copyFromBuilder(newObjectTagging);
        }

        @Override
        public final Builder newObjectTagging(Collection<S3Tag> newObjectTagging) {
            this.newObjectTagging = S3TagSetCopier.copy(newObjectTagging);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newObjectTagging(S3Tag ... newObjectTagging) {
            this.newObjectTagging(Arrays.asList(newObjectTagging));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newObjectTagging(Consumer<S3Tag.Builder> ... newObjectTagging) {
            this.newObjectTagging(Stream.of(newObjectTagging).map(c -> (S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRedirectLocation() {
            return this.redirectLocation;
        }

        public final void setRedirectLocation(String redirectLocation) {
            this.redirectLocation = redirectLocation;
        }

        @Override
        public final Builder redirectLocation(String redirectLocation) {
            this.redirectLocation = redirectLocation;
            return this;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(S3StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final Instant getUnModifiedSinceConstraint() {
            return this.unModifiedSinceConstraint;
        }

        public final void setUnModifiedSinceConstraint(Instant unModifiedSinceConstraint) {
            this.unModifiedSinceConstraint = unModifiedSinceConstraint;
        }

        @Override
        public final Builder unModifiedSinceConstraint(Instant unModifiedSinceConstraint) {
            this.unModifiedSinceConstraint = unModifiedSinceConstraint;
            return this;
        }

        public final String getSseAwsKmsKeyId() {
            return this.sseAwsKmsKeyId;
        }

        public final void setSseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        }

        @Override
        public final Builder sseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
            return this;
        }

        public final String getTargetKeyPrefix() {
            return this.targetKeyPrefix;
        }

        public final void setTargetKeyPrefix(String targetKeyPrefix) {
            this.targetKeyPrefix = targetKeyPrefix;
        }

        @Override
        public final Builder targetKeyPrefix(String targetKeyPrefix) {
            this.targetKeyPrefix = targetKeyPrefix;
            return this;
        }

        public final String getObjectLockLegalHoldStatus() {
            return this.objectLockLegalHoldStatus;
        }

        public final void setObjectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(S3ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus(objectLockLegalHoldStatus == null ? null : objectLockLegalHoldStatus.toString());
            return this;
        }

        public final String getObjectLockMode() {
            return this.objectLockMode;
        }

        public final void setObjectLockMode(String objectLockMode) {
            this.objectLockMode = objectLockMode;
        }

        @Override
        public final Builder objectLockMode(String objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        @Override
        public final Builder objectLockMode(S3ObjectLockMode objectLockMode) {
            this.objectLockMode(objectLockMode == null ? null : objectLockMode.toString());
            return this;
        }

        public final Instant getObjectLockRetainUntilDate() {
            return this.objectLockRetainUntilDate;
        }

        public final void setObjectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
        }

        @Override
        public final Builder objectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        public final Boolean getBucketKeyEnabled() {
            return this.bucketKeyEnabled;
        }

        public final void setBucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
        }

        @Override
        public final Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(S3ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        public S3CopyObjectOperation build() {
            return new S3CopyObjectOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3CopyObjectOperation> {
        public Builder targetResource(String var1);

        public Builder cannedAccessControlList(String var1);

        public Builder cannedAccessControlList(S3CannedAccessControlList var1);

        public Builder accessControlGrants(Collection<S3Grant> var1);

        public Builder accessControlGrants(S3Grant ... var1);

        public Builder accessControlGrants(Consumer<S3Grant.Builder> ... var1);

        public Builder metadataDirective(String var1);

        public Builder metadataDirective(S3MetadataDirective var1);

        public Builder modifiedSinceConstraint(Instant var1);

        public Builder newObjectMetadata(S3ObjectMetadata var1);

        default public Builder newObjectMetadata(Consumer<S3ObjectMetadata.Builder> newObjectMetadata) {
            return this.newObjectMetadata((S3ObjectMetadata)((S3ObjectMetadata.Builder)S3ObjectMetadata.builder().applyMutation(newObjectMetadata)).build());
        }

        public Builder newObjectTagging(Collection<S3Tag> var1);

        public Builder newObjectTagging(S3Tag ... var1);

        public Builder newObjectTagging(Consumer<S3Tag.Builder> ... var1);

        public Builder redirectLocation(String var1);

        public Builder requesterPays(Boolean var1);

        public Builder storageClass(String var1);

        public Builder storageClass(S3StorageClass var1);

        public Builder unModifiedSinceConstraint(Instant var1);

        public Builder sseAwsKmsKeyId(String var1);

        public Builder targetKeyPrefix(String var1);

        public Builder objectLockLegalHoldStatus(String var1);

        public Builder objectLockLegalHoldStatus(S3ObjectLockLegalHoldStatus var1);

        public Builder objectLockMode(String var1);

        public Builder objectLockMode(S3ObjectLockMode var1);

        public Builder objectLockRetainUntilDate(Instant var1);

        public Builder bucketKeyEnabled(Boolean var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(S3ChecksumAlgorithm var1);
    }
}

