/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3GlacierJobTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3InitiateRestoreObjectOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3InitiateRestoreObjectOperation> {
    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationInDays").getter(S3InitiateRestoreObjectOperation.getter(S3InitiateRestoreObjectOperation::expirationInDays)).setter(S3InitiateRestoreObjectOperation.setter(Builder::expirationInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays").unmarshallLocationName("ExpirationInDays").build()}).build();
    private static final SdkField<String> GLACIER_JOB_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlacierJobTier").getter(S3InitiateRestoreObjectOperation.getter(S3InitiateRestoreObjectOperation::glacierJobTierAsString)).setter(S3InitiateRestoreObjectOperation.setter(Builder::glacierJobTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlacierJobTier").unmarshallLocationName("GlacierJobTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_IN_DAYS_FIELD, GLACIER_JOB_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3InitiateRestoreObjectOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer expirationInDays;
    private final String glacierJobTier;

    private S3InitiateRestoreObjectOperation(BuilderImpl builder) {
        this.expirationInDays = builder.expirationInDays;
        this.glacierJobTier = builder.glacierJobTier;
    }

    public final Integer expirationInDays() {
        return this.expirationInDays;
    }

    public final S3GlacierJobTier glacierJobTier() {
        return S3GlacierJobTier.fromValue(this.glacierJobTier);
    }

    public final String glacierJobTierAsString() {
        return this.glacierJobTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.glacierJobTierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3InitiateRestoreObjectOperation)) {
            return false;
        }
        S3InitiateRestoreObjectOperation other = (S3InitiateRestoreObjectOperation)obj;
        return Objects.equals(this.expirationInDays(), other.expirationInDays()) && Objects.equals(this.glacierJobTierAsString(), other.glacierJobTierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3InitiateRestoreObjectOperation").add("ExpirationInDays", (Object)this.expirationInDays()).add("GlacierJobTier", (Object)this.glacierJobTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpirationInDays": {
                return Optional.ofNullable(clazz.cast(this.expirationInDays()));
            }
            case "GlacierJobTier": {
                return Optional.ofNullable(clazz.cast(this.glacierJobTierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExpirationInDays", EXPIRATION_IN_DAYS_FIELD);
        map.put("GlacierJobTier", GLACIER_JOB_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3InitiateRestoreObjectOperation, T> g) {
        return obj -> g.apply((S3InitiateRestoreObjectOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer expirationInDays;
        private String glacierJobTier;

        private BuilderImpl() {
        }

        private BuilderImpl(S3InitiateRestoreObjectOperation model) {
            this.expirationInDays(model.expirationInDays);
            this.glacierJobTier(model.glacierJobTier);
        }

        public final Integer getExpirationInDays() {
            return this.expirationInDays;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        @Override
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final String getGlacierJobTier() {
            return this.glacierJobTier;
        }

        public final void setGlacierJobTier(String glacierJobTier) {
            this.glacierJobTier = glacierJobTier;
        }

        @Override
        public final Builder glacierJobTier(String glacierJobTier) {
            this.glacierJobTier = glacierJobTier;
            return this;
        }

        @Override
        public final Builder glacierJobTier(S3GlacierJobTier glacierJobTier) {
            this.glacierJobTier(glacierJobTier == null ? null : glacierJobTier.toString());
            return this;
        }

        public S3InitiateRestoreObjectOperation build() {
            return new S3InitiateRestoreObjectOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3InitiateRestoreObjectOperation> {
        public Builder expirationInDays(Integer var1);

        public Builder glacierJobTier(String var1);

        public Builder glacierJobTier(S3GlacierJobTier var1);
    }
}

