/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.SSEKMSEncryption;
import software.amazon.awssdk.services.s3control.model.SSES3Encryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratedManifestEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratedManifestEncryption> {
    private static final SdkField<SSES3Encryption> SSES3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSES3").getter(GeneratedManifestEncryption.getter(GeneratedManifestEncryption::sses3)).setter(GeneratedManifestEncryption.setter(Builder::sses3)).constructor(SSES3Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-S3").unmarshallLocationName("SSE-S3").build()}).build();
    private static final SdkField<SSEKMSEncryption> SSEKMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSEKMS").getter(GeneratedManifestEncryption.getter(GeneratedManifestEncryption::ssekms)).setter(GeneratedManifestEncryption.setter(Builder::ssekms)).constructor(SSEKMSEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS").unmarshallLocationName("SSE-KMS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSES3_FIELD, SSEKMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeneratedManifestEncryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SSES3Encryption sses3;
    private final SSEKMSEncryption ssekms;

    private GeneratedManifestEncryption(BuilderImpl builder) {
        this.sses3 = builder.sses3;
        this.ssekms = builder.ssekms;
    }

    public final SSES3Encryption sses3() {
        return this.sses3;
    }

    public final SSEKMSEncryption ssekms() {
        return this.ssekms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sses3());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedManifestEncryption)) {
            return false;
        }
        GeneratedManifestEncryption other = (GeneratedManifestEncryption)obj;
        return Objects.equals(this.sses3(), other.sses3()) && Objects.equals(this.ssekms(), other.ssekms());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratedManifestEncryption").add("SSES3", (Object)this.sses3()).add("SSEKMS", (Object)this.ssekms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSES3": {
                return Optional.ofNullable(clazz.cast(this.sses3()));
            }
            case "SSEKMS": {
                return Optional.ofNullable(clazz.cast(this.ssekms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SSE-S3", SSES3_FIELD);
        map.put("SSE-KMS", SSEKMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneratedManifestEncryption, T> g) {
        return obj -> g.apply((GeneratedManifestEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SSES3Encryption sses3;
        private SSEKMSEncryption ssekms;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedManifestEncryption model) {
            this.sses3(model.sses3);
            this.ssekms(model.ssekms);
        }

        public final SSES3Encryption.Builder getSses3() {
            return this.sses3 != null ? this.sses3.toBuilder() : null;
        }

        public final void setSses3(SSES3Encryption.BuilderImpl sses3) {
            this.sses3 = sses3 != null ? sses3.build() : null;
        }

        @Override
        public final Builder sses3(SSES3Encryption sses3) {
            this.sses3 = sses3;
            return this;
        }

        public final SSEKMSEncryption.Builder getSsekms() {
            return this.ssekms != null ? this.ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSEncryption.BuilderImpl ssekms) {
            this.ssekms = ssekms != null ? ssekms.build() : null;
        }

        @Override
        public final Builder ssekms(SSEKMSEncryption ssekms) {
            this.ssekms = ssekms;
            return this;
        }

        public GeneratedManifestEncryption build() {
            return new GeneratedManifestEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratedManifestEncryption> {
        public Builder sses3(SSES3Encryption var1);

        default public Builder sses3(Consumer<SSES3Encryption.Builder> sses3) {
            return this.sses3((SSES3Encryption)((SSES3Encryption.Builder)SSES3Encryption.builder().applyMutation(sses3)).build());
        }

        public Builder ssekms(SSEKMSEncryption var1);

        default public Builder ssekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
            return this.ssekms((SSEKMSEncryption)((SSEKMSEncryption.Builder)SSEKMSEncryption.builder().applyMutation(ssekms)).build());
        }
    }
}

