/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsResponse;

public class ListCallerAccessGrantsPublisher
implements SdkPublisher<ListCallerAccessGrantsResponse> {
    private final S3ControlAsyncClient client;
    private final ListCallerAccessGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCallerAccessGrantsPublisher(S3ControlAsyncClient client, ListCallerAccessGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCallerAccessGrantsPublisher(S3ControlAsyncClient client, ListCallerAccessGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCallerAccessGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCallerAccessGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListCallerAccessGrantsEntry> callerAccessGrantsList() {
        Function<ListCallerAccessGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.callerAccessGrantsList() != null) {
                return response.callerAccessGrantsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCallerAccessGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCallerAccessGrantsResponseFetcher
    implements AsyncPageFetcher<ListCallerAccessGrantsResponse> {
        private ListCallerAccessGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListCallerAccessGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCallerAccessGrantsResponse> nextPage(ListCallerAccessGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListCallerAccessGrantsPublisher.this.client.listCallerAccessGrants(ListCallerAccessGrantsPublisher.this.firstRequest);
            }
            return ListCallerAccessGrantsPublisher.this.client.listCallerAccessGrants((ListCallerAccessGrantsRequest)((Object)ListCallerAccessGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

