/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsResponse;

public class ListAccessGrantsPublisher
implements SdkPublisher<ListAccessGrantsResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessGrantsPublisher(S3ControlAsyncClient client, ListAccessGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessGrantsPublisher(S3ControlAsyncClient client, ListAccessGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessGrantsResponseFetcher
    implements AsyncPageFetcher<ListAccessGrantsResponse> {
        private ListAccessGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessGrantsResponse> nextPage(ListAccessGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsPublisher.this.client.listAccessGrants(ListAccessGrantsPublisher.this.firstRequest);
            }
            return ListAccessGrantsPublisher.this.client.listAccessGrants((ListAccessGrantsRequest)((Object)ListAccessGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

