/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.JobManifest;
import software.amazon.awssdk.services.s3control.model.JobManifestGenerator;
import software.amazon.awssdk.services.s3control.model.JobOperation;
import software.amazon.awssdk.services.s3control.model.JobReport;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.S3Tag;
import software.amazon.awssdk.services.s3control.model.S3TagSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CreateJobRequest.getter(CreateJobRequest::accountId)).setter(CreateJobRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<Boolean> CONFIRMATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConfirmationRequired").getter(CreateJobRequest.getter(CreateJobRequest::confirmationRequired)).setter(CreateJobRequest.setter(Builder::confirmationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfirmationRequired").unmarshallLocationName("ConfirmationRequired").build()}).build();
    private static final SdkField<JobOperation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operation").getter(CreateJobRequest.getter(CreateJobRequest::operation)).setter(CreateJobRequest.setter(Builder::operation)).constructor(JobOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").unmarshallLocationName("Operation").build()}).build();
    private static final SdkField<JobReport> REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Report").getter(CreateJobRequest.getter(CreateJobRequest::report)).setter(CreateJobRequest.setter(Builder::report)).constructor(JobReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").unmarshallLocationName("Report").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateJobRequest.getter(CreateJobRequest::clientRequestToken)).setter(CreateJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").unmarshallLocationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<JobManifest> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Manifest").getter(CreateJobRequest.getter(CreateJobRequest::manifest)).setter(CreateJobRequest.setter(Builder::manifest)).constructor(JobManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manifest").unmarshallLocationName("Manifest").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateJobRequest.getter(CreateJobRequest::description)).setter(CreateJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateJobRequest.getter(CreateJobRequest::priority)).setter(CreateJobRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateJobRequest.getter(CreateJobRequest::roleArn)).setter(CreateJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").unmarshallLocationName("RoleArn").build()}).build();
    private static final SdkField<List<S3Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateJobRequest.getter(CreateJobRequest::tags)).setter(CreateJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobManifestGenerator> MANIFEST_GENERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestGenerator").getter(CreateJobRequest.getter(CreateJobRequest::manifestGenerator)).setter(CreateJobRequest.setter(Builder::manifestGenerator)).constructor(JobManifestGenerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestGenerator").unmarshallLocationName("ManifestGenerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONFIRMATION_REQUIRED_FIELD, OPERATION_FIELD, REPORT_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MANIFEST_FIELD, DESCRIPTION_FIELD, PRIORITY_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, MANIFEST_GENERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateJobRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final Boolean confirmationRequired;
    private final JobOperation operation;
    private final JobReport report;
    private final String clientRequestToken;
    private final JobManifest manifest;
    private final String description;
    private final Integer priority;
    private final String roleArn;
    private final List<S3Tag> tags;
    private final JobManifestGenerator manifestGenerator;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.confirmationRequired = builder.confirmationRequired;
        this.operation = builder.operation;
        this.report = builder.report;
        this.clientRequestToken = builder.clientRequestToken;
        this.manifest = builder.manifest;
        this.description = builder.description;
        this.priority = builder.priority;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.manifestGenerator = builder.manifestGenerator;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Boolean confirmationRequired() {
        return this.confirmationRequired;
    }

    public final JobOperation operation() {
        return this.operation;
    }

    public final JobReport report() {
        return this.report;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final JobManifest manifest() {
        return this.manifest;
    }

    public final String description() {
        return this.description;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<S3Tag> tags() {
        return this.tags;
    }

    public final JobManifestGenerator manifestGenerator() {
        return this.manifestGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.report());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestGenerator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.confirmationRequired(), other.confirmationRequired()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.report(), other.report()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.manifest(), other.manifest()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.manifestGenerator(), other.manifestGenerator());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("AccountId", (Object)this.accountId()).add("ConfirmationRequired", (Object)this.confirmationRequired()).add("Operation", (Object)this.operation()).add("Report", (Object)this.report()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Manifest", (Object)this.manifest()).add("Description", (Object)this.description()).add("Priority", (Object)this.priority()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ManifestGenerator", (Object)this.manifestGenerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ConfirmationRequired": {
                return Optional.ofNullable(clazz.cast(this.confirmationRequired()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "Report": {
                return Optional.ofNullable(clazz.cast(this.report()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ManifestGenerator": {
                return Optional.ofNullable(clazz.cast(this.manifestGenerator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("ConfirmationRequired", CONFIRMATION_REQUIRED_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Report", REPORT_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Manifest", MANIFEST_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ManifestGenerator", MANIFEST_GENERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private Boolean confirmationRequired;
        private JobOperation operation;
        private JobReport report;
        private String clientRequestToken;
        private JobManifest manifest;
        private String description;
        private Integer priority;
        private String roleArn;
        private List<S3Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private JobManifestGenerator manifestGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.confirmationRequired(model.confirmationRequired);
            this.operation(model.operation);
            this.report(model.report);
            this.clientRequestToken(model.clientRequestToken);
            this.manifest(model.manifest);
            this.description(model.description);
            this.priority(model.priority);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.manifestGenerator(model.manifestGenerator);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getConfirmationRequired() {
            return this.confirmationRequired;
        }

        public final void setConfirmationRequired(Boolean confirmationRequired) {
            this.confirmationRequired = confirmationRequired;
        }

        @Override
        public final Builder confirmationRequired(Boolean confirmationRequired) {
            this.confirmationRequired = confirmationRequired;
            return this;
        }

        public final JobOperation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        public final void setOperation(JobOperation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public final Builder operation(JobOperation operation) {
            this.operation = operation;
            return this;
        }

        public final JobReport.Builder getReport() {
            return this.report != null ? this.report.toBuilder() : null;
        }

        public final void setReport(JobReport.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        public final Builder report(JobReport report) {
            this.report = report;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final JobManifest.Builder getManifest() {
            return this.manifest != null ? this.manifest.toBuilder() : null;
        }

        public final void setManifest(JobManifest.BuilderImpl manifest) {
            this.manifest = manifest != null ? manifest.build() : null;
        }

        @Override
        public final Builder manifest(JobManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<S3Tag.Builder> getTags() {
            List<S3Tag.Builder> result = S3TagSetCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<S3Tag.BuilderImpl> tags) {
            this.tags = S3TagSetCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<S3Tag> tags) {
            this.tags = S3TagSetCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(S3Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<S3Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final JobManifestGenerator.Builder getManifestGenerator() {
            return this.manifestGenerator != null ? this.manifestGenerator.toBuilder() : null;
        }

        public final void setManifestGenerator(JobManifestGenerator.BuilderImpl manifestGenerator) {
            this.manifestGenerator = manifestGenerator != null ? manifestGenerator.build() : null;
        }

        @Override
        public final Builder manifestGenerator(JobManifestGenerator manifestGenerator) {
            this.manifestGenerator = manifestGenerator;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder accountId(String var1);

        public Builder confirmationRequired(Boolean var1);

        public Builder operation(JobOperation var1);

        default public Builder operation(Consumer<JobOperation.Builder> operation) {
            return this.operation((JobOperation)((JobOperation.Builder)JobOperation.builder().applyMutation(operation)).build());
        }

        public Builder report(JobReport var1);

        default public Builder report(Consumer<JobReport.Builder> report) {
            return this.report((JobReport)((JobReport.Builder)JobReport.builder().applyMutation(report)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder manifest(JobManifest var1);

        default public Builder manifest(Consumer<JobManifest.Builder> manifest) {
            return this.manifest((JobManifest)((JobManifest.Builder)JobManifest.builder().applyMutation(manifest)).build());
        }

        public Builder description(String var1);

        public Builder priority(Integer var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<S3Tag> var1);

        public Builder tags(S3Tag ... var1);

        public Builder tags(Consumer<S3Tag.Builder> ... var1);

        public Builder manifestGenerator(JobManifestGenerator var1);

        default public Builder manifestGenerator(Consumer<JobManifestGenerator.Builder> manifestGenerator) {
            return this.manifestGenerator((JobManifestGenerator)((JobManifestGenerator.Builder)JobManifestGenerator.builder().applyMutation(manifestGenerator)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

