/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.s3control.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleUrl;
import software.amazon.awssdk.services.s3control.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3ControlEndpointProvider
implements S3ControlEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3ControlEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(S3ControlEndpointParams params, String region) {
        RuleResult result = DefaultS3ControlEndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Region must be set");
    }

    private static RuleResult endpointRule1(S3ControlEndpointParams params, String region) {
        if (region != null) {
            RulePartition partitionResult;
            if (params.useFips().booleanValue() && (partitionResult = RulesFunctions.awsPartition(region)) != null && "aws-cn".equals(partitionResult.name())) {
                return RuleResult.error("Partition does not support FIPS");
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule3(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule16(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule37(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule44(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule49(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule81(params, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule113(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(S3ControlEndpointParams params, String region) {
        if (params.outpostId() != null) {
            return DefaultS3ControlEndpointProvider.endpointRule4(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(S3ControlEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() == null) {
                return RuleResult.error("AccountId is required but not set");
            }
            if (params.accountId() != null && !RulesFunctions.isValidHostLabel(params.accountId(), false)) {
                return RuleResult.error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
            }
            if (!RulesFunctions.isValidHostLabel(params.outpostId(), false)) {
                return RuleResult.error("OutpostId must only contain a-z, A-Z, 0-9 and `-`.");
            }
            if (params.endpoint() != null && params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule9(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(region, true)) {
            RuleUrl url;
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + region + "." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + region + "." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(S3ControlEndpointParams params, String region) {
        String accessPointSuffix;
        if (params.accessPointName() != null && (accessPointSuffix = RulesFunctions.substring(params.accessPointName(), 0, 7, true)) != null && "--xa-s3".equals(accessPointSuffix)) {
            return DefaultS3ControlEndpointProvider.endpointRule17(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(S3ControlEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleUrl url;
            if (params.endpoint() != null && params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3Express does not support Dual-stack.");
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule21(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule24(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule27(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule30(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule33(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized S3Express Access Point name format.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.accessPointName(), 7, 15, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.accessPointName(), 15, 17, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.accessPointName(), 7, 16, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.accessPointName(), 16, 18, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.accessPointName(), 7, 20, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.accessPointName(), 20, 22, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.accessPointName(), 7, 21, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.accessPointName(), 21, 23, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.accessPointName(), 7, 27, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.accessPointName(), 27, 29, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(S3ControlEndpointParams params, String region) {
        if (params.useS3ExpressControlEndpoint() != null && params.useS3ExpressControlEndpoint().booleanValue()) {
            return DefaultS3ControlEndpointProvider.endpointRule38(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(S3ControlEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleUrl url;
            if (params.endpoint() != null && params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3Express does not support Dual-stack.");
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule44(S3ControlEndpointParams params, String region) {
        RuleUrl url;
        if ("snow".equals(region) && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
            return DefaultS3ControlEndpointProvider.endpointRule45(params, region, url);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule45(S3ControlEndpointParams params, String region, RuleUrl url) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3 Snow does not support DualStack");
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.error("S3 Snow does not support FIPS");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule49(S3ControlEndpointParams params, String region) {
        RuleArn accessPointArn;
        if (params.accessPointName() != null && (accessPointArn = RulesFunctions.awsParseArn(params.accessPointName())) != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule50(params, accessPointArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule50(S3ControlEndpointParams params, RuleArn accessPointArn, String region) {
        String arnType = RulesFunctions.listAccess(accessPointArn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            return DefaultS3ControlEndpointProvider.endpointRule51(params, accessPointArn, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule51(S3ControlEndpointParams params, RuleArn accessPointArn, String region) {
        if ("s3-outposts".equals(accessPointArn.service())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule52(params, accessPointArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The Outpost Id was not set");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule52(S3ControlEndpointParams params, RuleArn accessPointArn, String region) {
        String outpostId = RulesFunctions.listAccess(accessPointArn.resourceId(), 1);
        if (outpostId != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule53(params, outpostId, accessPointArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `" + outpostId + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule53(S3ControlEndpointParams params, String outpostId, RuleArn accessPointArn, String region) {
        if (RulesFunctions.isValidHostLabel(outpostId, false)) {
            if (params.endpoint() != null && params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(accessPointArn.region(), region)) {
                return RuleResult.error("Invalid configuration: region from ARN `" + accessPointArn.region() + "` does not match client region `" + region + "` and UseArnRegion is `false`");
            }
            return DefaultS3ControlEndpointProvider.endpointRule56(params, region, accessPointArn, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule56(S3ControlEndpointParams params, String region, RuleArn accessPointArn, String outpostId) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            return DefaultS3ControlEndpointProvider.endpointRule57(params, accessPointArn, partitionResult, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule57(S3ControlEndpointParams params, RuleArn accessPointArn, RulePartition partitionResult, String outpostId) {
        RulePartition arnPartition = RulesFunctions.awsPartition(accessPointArn.region());
        if (arnPartition != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule58(params, arnPartition, partitionResult, accessPointArn, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but ARN has `" + arnPartition.name() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule58(S3ControlEndpointParams params, RulePartition arnPartition, RulePartition partitionResult, RuleArn accessPointArn, String outpostId) {
        if (RulesFunctions.stringEquals(arnPartition.name(), partitionResult.name())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule59(params, accessPointArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region in ARN: `" + accessPointArn.region() + "` (invalid DNS name)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule59(S3ControlEndpointParams params, RuleArn accessPointArn, RulePartition arnPartition, String outpostId) {
        if (RulesFunctions.isValidHostLabel(accessPointArn.region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule60(params, accessPointArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: missing account ID");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule60(S3ControlEndpointParams params, RuleArn accessPointArn, RulePartition arnPartition, String outpostId) {
        if (!"".equals(accessPointArn.accountId())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule61(params, accessPointArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + accessPointArn.accountId() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule61(S3ControlEndpointParams params, RuleArn accessPointArn, RulePartition arnPartition, String outpostId) {
        if (RulesFunctions.isValidHostLabel(accessPointArn.accountId(), false)) {
            if (params.accountId() != null && !RulesFunctions.stringEquals(params.accountId(), accessPointArn.accountId())) {
                return RuleResult.error("Invalid ARN: the accountId specified in the ARN (`" + accessPointArn.accountId() + "`) does not match the parameter (`" + params.accountId() + "`)");
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule63(params, accessPointArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected a 4-component resource");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule63(S3ControlEndpointParams params, RuleArn accessPointArn, RulePartition arnPartition, String outpostId) {
        String outpostType = RulesFunctions.listAccess(accessPointArn.resourceId(), 2);
        if (outpostType != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule64(params, accessPointArn, outpostType, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: expected an access point name");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule64(S3ControlEndpointParams params, RuleArn accessPointArn, String outpostType, RulePartition arnPartition, String outpostId) {
        String accessPointName = RulesFunctions.listAccess(accessPointArn.resourceId(), 3);
        if (accessPointName != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule65(params, outpostType, accessPointArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Expected an outpost type `accesspoint`, found `" + outpostType + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule65(S3ControlEndpointParams params, String outpostType, RuleArn accessPointArn, RulePartition arnPartition, String outpostId) {
        if ("accesspoint".equals(outpostType)) {
            RuleUrl url;
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + accessPointArn.region() + "." + arnPartition.dualStackDnsSuffix())).putHeader("x-amz-account-id", accessPointArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(accessPointArn.region()).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + accessPointArn.region() + "." + arnPartition.dnsSuffix())).putHeader("x-amz-account-id", accessPointArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(accessPointArn.region()).build())).build());
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + accessPointArn.region() + "." + arnPartition.dualStackDnsSuffix())).putHeader("x-amz-account-id", accessPointArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(accessPointArn.region()).build())).build());
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putHeader("x-amz-account-id", accessPointArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(accessPointArn.region()).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + accessPointArn.region() + "." + arnPartition.dnsSuffix())).putHeader("x-amz-account-id", accessPointArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(accessPointArn.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule81(S3ControlEndpointParams params, String region) {
        RuleArn bucketArn;
        if (params.bucket() != null && (bucketArn = RulesFunctions.awsParseArn(params.bucket())) != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule82(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule82(S3ControlEndpointParams params, RuleArn bucketArn, String region) {
        String arnType = RulesFunctions.listAccess(bucketArn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            return DefaultS3ControlEndpointProvider.endpointRule83(params, bucketArn, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule83(S3ControlEndpointParams params, RuleArn bucketArn, String region) {
        if ("s3-outposts".equals(bucketArn.service())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule84(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The Outpost Id was not set");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule84(S3ControlEndpointParams params, RuleArn bucketArn, String region) {
        String outpostId = RulesFunctions.listAccess(bucketArn.resourceId(), 1);
        if (outpostId != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule85(params, outpostId, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `" + outpostId + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule85(S3ControlEndpointParams params, String outpostId, RuleArn bucketArn, String region) {
        if (RulesFunctions.isValidHostLabel(outpostId, false)) {
            if (params.endpoint() != null && params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(bucketArn.region(), region)) {
                return RuleResult.error("Invalid configuration: region from ARN `" + bucketArn.region() + "` does not match client region `" + region + "` and UseArnRegion is `false`");
            }
            return DefaultS3ControlEndpointProvider.endpointRule88(params, bucketArn, region, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule88(S3ControlEndpointParams params, RuleArn bucketArn, String region, String outpostId) {
        RulePartition arnPartition = RulesFunctions.awsPartition(bucketArn.region());
        if (arnPartition != null) {
            return DefaultS3ControlEndpointProvider.endpointRule89(params, region, arnPartition, bucketArn, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule89(S3ControlEndpointParams params, String region, RulePartition arnPartition, RuleArn bucketArn, String outpostId) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule90(params, arnPartition, partitionResult, bucketArn, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but ARN has `" + arnPartition.name() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule90(S3ControlEndpointParams params, RulePartition arnPartition, RulePartition partitionResult, RuleArn bucketArn, String outpostId) {
        if (RulesFunctions.stringEquals(arnPartition.name(), partitionResult.name())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule91(params, bucketArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region in ARN: `" + bucketArn.region() + "` (invalid DNS name)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule91(S3ControlEndpointParams params, RuleArn bucketArn, RulePartition arnPartition, String outpostId) {
        if (RulesFunctions.isValidHostLabel(bucketArn.region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule92(params, bucketArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: missing account ID");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule92(S3ControlEndpointParams params, RuleArn bucketArn, RulePartition arnPartition, String outpostId) {
        if (!"".equals(bucketArn.accountId())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule93(params, bucketArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + bucketArn.accountId() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule93(S3ControlEndpointParams params, RuleArn bucketArn, RulePartition arnPartition, String outpostId) {
        if (RulesFunctions.isValidHostLabel(bucketArn.accountId(), false)) {
            if (params.accountId() != null && !RulesFunctions.stringEquals(params.accountId(), bucketArn.accountId())) {
                return RuleResult.error("Invalid ARN: the accountId specified in the ARN (`" + bucketArn.accountId() + "`) does not match the parameter (`" + params.accountId() + "`)");
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule95(params, bucketArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected a 4-component resource");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule95(S3ControlEndpointParams params, RuleArn bucketArn, RulePartition arnPartition, String outpostId) {
        String outpostType = RulesFunctions.listAccess(bucketArn.resourceId(), 2);
        if (outpostType != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule96(params, bucketArn, outpostType, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: expected a bucket name");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule96(S3ControlEndpointParams params, RuleArn bucketArn, String outpostType, RulePartition arnPartition, String outpostId) {
        String bucketName = RulesFunctions.listAccess(bucketArn.resourceId(), 3);
        if (bucketName != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule97(params, outpostType, bucketArn, arnPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected an outpost type `bucket`, found `" + outpostType + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule97(S3ControlEndpointParams params, String outpostType, RuleArn bucketArn, RulePartition arnPartition, String outpostId) {
        if ("bucket".equals(outpostType)) {
            RuleUrl url;
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + bucketArn.region() + "." + arnPartition.dualStackDnsSuffix())).putHeader("x-amz-account-id", bucketArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + bucketArn.region() + "." + arnPartition.dnsSuffix())).putHeader("x-amz-account-id", bucketArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + bucketArn.region() + "." + arnPartition.dualStackDnsSuffix())).putHeader("x-amz-account-id", bucketArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putHeader("x-amz-account-id", bucketArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + bucketArn.region() + "." + arnPartition.dnsSuffix())).putHeader("x-amz-account-id", bucketArn.accountId()).putHeader("x-amz-outpost-id", outpostId).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule113(S3ControlEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule114(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule114(S3ControlEndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(region, true)) {
            if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() == null) {
                return RuleResult.error("AccountId is required but not set");
            }
            if (params.accountId() != null && !RulesFunctions.isValidHostLabel(params.accountId(), false)) {
                return RuleResult.error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
            }
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule117(params, region);
            if (result.isResolved()) {
                return result;
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule117(S3ControlEndpointParams params, String region) {
        RuleUrl url;
        if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
            }
            if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.accountId() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

