/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.AccessGrantsLocationConfiguration;
import software.amazon.awssdk.services.s3control.model.Grantee;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.S3PrefixType;
import software.amazon.awssdk.services.s3control.model.Tag;
import software.amazon.awssdk.services.s3control.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessGrantRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, CreateAccessGrantRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::accountId)).setter(CreateAccessGrantRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsLocationId").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::accessGrantsLocationId)).setter(CreateAccessGrantRequest.setter(Builder::accessGrantsLocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationId").unmarshallLocationName("AccessGrantsLocationId").build()}).build();
    private static final SdkField<AccessGrantsLocationConfiguration> ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessGrantsLocationConfiguration").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::accessGrantsLocationConfiguration)).setter(CreateAccessGrantRequest.setter(Builder::accessGrantsLocationConfiguration)).constructor(AccessGrantsLocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationConfiguration").unmarshallLocationName("AccessGrantsLocationConfiguration").build()}).build();
    private static final SdkField<Grantee> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Grantee").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::grantee)).setter(CreateAccessGrantRequest.setter(Builder::grantee)).constructor(Grantee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").unmarshallLocationName("Grantee").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::permissionAsString)).setter(CreateAccessGrantRequest.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::applicationArn)).setter(CreateAccessGrantRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").unmarshallLocationName("ApplicationArn").build()}).build();
    private static final SdkField<String> S3_PREFIX_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3PrefixType").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::s3PrefixTypeAsString)).setter(CreateAccessGrantRequest.setter(Builder::s3PrefixType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PrefixType").unmarshallLocationName("S3PrefixType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAccessGrantRequest.getter(CreateAccessGrantRequest::tags)).setter(CreateAccessGrantRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACCESS_GRANTS_LOCATION_ID_FIELD, ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD, GRANTEE_FIELD, PERMISSION_FIELD, APPLICATION_ARN_FIELD, S3_PREFIX_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessGrantRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String accessGrantsLocationId;
    private final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;
    private final Grantee grantee;
    private final String permission;
    private final String applicationArn;
    private final String s3PrefixType;
    private final List<Tag> tags;

    private CreateAccessGrantRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.accessGrantsLocationConfiguration = builder.accessGrantsLocationConfiguration;
        this.grantee = builder.grantee;
        this.permission = builder.permission;
        this.applicationArn = builder.applicationArn;
        this.s3PrefixType = builder.s3PrefixType;
        this.tags = builder.tags;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String accessGrantsLocationId() {
        return this.accessGrantsLocationId;
    }

    public final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration() {
        return this.accessGrantsLocationConfiguration;
    }

    public final Grantee grantee() {
        return this.grantee;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final S3PrefixType s3PrefixType() {
        return S3PrefixType.fromValue(this.s3PrefixType);
    }

    public final String s3PrefixTypeAsString() {
        return this.s3PrefixType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PrefixTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantRequest)) {
            return false;
        }
        CreateAccessGrantRequest other = (CreateAccessGrantRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accessGrantsLocationId(), other.accessGrantsLocationId()) && Objects.equals(this.accessGrantsLocationConfiguration(), other.accessGrantsLocationConfiguration()) && Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.s3PrefixTypeAsString(), other.s3PrefixTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessGrantRequest").add("AccountId", (Object)this.accountId()).add("AccessGrantsLocationId", (Object)this.accessGrantsLocationId()).add("AccessGrantsLocationConfiguration", (Object)this.accessGrantsLocationConfiguration()).add("Grantee", (Object)this.grantee()).add("Permission", (Object)this.permissionAsString()).add("ApplicationArn", (Object)this.applicationArn()).add("S3PrefixType", (Object)this.s3PrefixTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AccessGrantsLocationId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationId()));
            }
            case "AccessGrantsLocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationConfiguration()));
            }
            case "Grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "S3PrefixType": {
                return Optional.ofNullable(clazz.cast(this.s3PrefixTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("AccessGrantsLocationId", ACCESS_GRANTS_LOCATION_ID_FIELD);
        map.put("AccessGrantsLocationConfiguration", ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD);
        map.put("Grantee", GRANTEE_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("S3PrefixType", S3_PREFIX_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantRequest, T> g) {
        return obj -> g.apply((CreateAccessGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String accessGrantsLocationId;
        private AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;
        private Grantee grantee;
        private String permission;
        private String applicationArn;
        private String s3PrefixType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.accessGrantsLocationId(model.accessGrantsLocationId);
            this.accessGrantsLocationConfiguration(model.accessGrantsLocationConfiguration);
            this.grantee(model.grantee);
            this.permission(model.permission);
            this.applicationArn(model.applicationArn);
            this.s3PrefixType(model.s3PrefixType);
            this.tags(model.tags);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final AccessGrantsLocationConfiguration.Builder getAccessGrantsLocationConfiguration() {
            return this.accessGrantsLocationConfiguration != null ? this.accessGrantsLocationConfiguration.toBuilder() : null;
        }

        public final void setAccessGrantsLocationConfiguration(AccessGrantsLocationConfiguration.BuilderImpl accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration != null ? accessGrantsLocationConfiguration.build() : null;
        }

        @Override
        public final Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration;
            return this;
        }

        public final Grantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getS3PrefixType() {
            return this.s3PrefixType;
        }

        public final void setS3PrefixType(String s3PrefixType) {
            this.s3PrefixType = s3PrefixType;
        }

        @Override
        public final Builder s3PrefixType(String s3PrefixType) {
            this.s3PrefixType = s3PrefixType;
            return this;
        }

        @Override
        public final Builder s3PrefixType(S3PrefixType s3PrefixType) {
            this.s3PrefixType(s3PrefixType == null ? null : s3PrefixType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessGrantRequest build() {
            return new CreateAccessGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessGrantRequest> {
        public Builder accountId(String var1);

        public Builder accessGrantsLocationId(String var1);

        public Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration var1);

        default public Builder accessGrantsLocationConfiguration(Consumer<AccessGrantsLocationConfiguration.Builder> accessGrantsLocationConfiguration) {
            return this.accessGrantsLocationConfiguration((AccessGrantsLocationConfiguration)((AccessGrantsLocationConfiguration.Builder)AccessGrantsLocationConfiguration.builder().applyMutation(accessGrantsLocationConfiguration)).build());
        }

        public Builder grantee(Grantee var1);

        default public Builder grantee(Consumer<Grantee.Builder> grantee) {
            return this.grantee((Grantee)((Grantee.Builder)Grantee.builder().applyMutation(grantee)).build());
        }

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder applicationArn(String var1);

        public Builder s3PrefixType(String var1);

        public Builder s3PrefixType(S3PrefixType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

