/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.s3control.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.s3control.endpoints.internal.RuleUrl;
import software.amazon.awssdk.services.s3control.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3ControlEndpointProvider
implements S3ControlEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3ControlEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(S3ControlEndpointParams params, LocalState locals) {
        RuleResult result = DefaultS3ControlEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultS3ControlEndpointProvider.endpointRule103(params, locals);
    }

    private static RuleResult endpointRule1(S3ControlEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule7(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule53(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule85(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(S3ControlEndpointParams params, LocalState locals) {
        if ("snow".equals(locals.region()) && params.endpoint() != null) {
            RuleUrl url = null;
            url = RulesFunctions.parseURL(params.endpoint());
            if (url != null) {
                locals = locals.toBuilder().url(url).build();
                return DefaultS3ControlEndpointProvider.endpointRule3(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(S3ControlEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule4(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule5(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(S3ControlEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("S3 Snow does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("S3 Snow does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.url().authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
    }

    private static RuleResult endpointRule7(S3ControlEndpointParams params, LocalState locals) {
        if (params.outpostId() != null) {
            return DefaultS3ControlEndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(S3ControlEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule9(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule20(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && "aws-cn".equals(locals.partitionResult().name())) {
            return RuleResult.error("Partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(S3ControlEndpointParams params, LocalState locals) {
        if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() == null) {
            return RuleResult.error("AccountId is required but not set");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(S3ControlEndpointParams params, LocalState locals) {
        if (params.accountId() != null && !RulesFunctions.isValidHostLabel(params.accountId(), false)) {
            return RuleResult.error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(S3ControlEndpointParams params, LocalState locals) {
        if (!RulesFunctions.isValidHostLabel(params.outpostId(), false)) {
            return RuleResult.error("OutpostId must only contain a-z, A-Z, 0-9 and `-`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null && params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule18(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleUrl url = null;
            url = RulesFunctions.parseURL(params.endpoint());
            if (url != null) {
                locals = locals.toBuilder().url(url).build();
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.url().authority() + locals.url().path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.region()).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(S3ControlEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.region()).build())).build());
    }

    private static RuleResult endpointRule20(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid region: region was not a valid DNS name.");
    }

    private static RuleResult endpointRule21(S3ControlEndpointParams params, LocalState locals) {
        if (params.accessPointName() != null) {
            RuleArn accessPointArn = null;
            accessPointArn = RulesFunctions.awsParseArn(params.accessPointName());
            if (accessPointArn != null) {
                RuleResult result = DefaultS3ControlEndpointProvider.endpointRule22(params, locals = locals.toBuilder().accessPointArn(accessPointArn).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultS3ControlEndpointProvider.endpointRule52(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(S3ControlEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.accessPointArn().resourceId(), 0);
        if (arnType != null && !"".equals((locals = locals.toBuilder().arnType(arnType).build()).arnType())) {
            return DefaultS3ControlEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(S3ControlEndpointParams params, LocalState locals) {
        if ("s3-outposts".equals(locals.accessPointArn().service())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule24(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule51(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(S3ControlEndpointParams params, LocalState locals) {
        String outpostId = null;
        outpostId = RulesFunctions.listAccess(locals.accessPointArn().resourceId(), 1);
        if (outpostId != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule25(params, locals = locals.toBuilder().outpostId(outpostId).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule50(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.outpostId(), false)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule26(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule27(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null && params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(S3ControlEndpointParams params, LocalState locals) {
        if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(locals.accessPointArn().region(), locals.region())) {
            return RuleResult.error("Invalid configuration: region from ARN `" + locals.accessPointArn().region() + "` does not match client region `" + locals.region() + "` and UseArnRegion is `false`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(S3ControlEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            locals = locals.toBuilder().partitionResult(partitionResult).build();
            return DefaultS3ControlEndpointProvider.endpointRule29(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(S3ControlEndpointParams params, LocalState locals) {
        RulePartition arnPartition = null;
        arnPartition = RulesFunctions.awsPartition(locals.accessPointArn().region());
        if (arnPartition != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule30(params, locals = locals.toBuilder().arnPartition(arnPartition).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule49(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.arnPartition().name(), locals.partitionResult().name())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule31(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule48(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule31(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.accessPointArn().region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule32(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule47(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule32(S3ControlEndpointParams params, LocalState locals) {
        if (!"".equals(locals.accessPointArn().accountId())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule33(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule46(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.accessPointArn().accountId(), false)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule34(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule35(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule45(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule34(S3ControlEndpointParams params, LocalState locals) {
        if (params.accountId() != null && !RulesFunctions.stringEquals(params.accountId(), locals.accessPointArn().accountId())) {
            return RuleResult.error("Invalid ARN: the accountId specified in the ARN (`" + locals.accessPointArn().accountId() + "`) does not match the parameter (`" + params.accountId() + "`)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(S3ControlEndpointParams params, LocalState locals) {
        String outpostType = null;
        outpostType = RulesFunctions.listAccess(locals.accessPointArn().resourceId(), 2);
        if (outpostType != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule36(params, locals = locals.toBuilder().outpostType(outpostType).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule44(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(S3ControlEndpointParams params, LocalState locals) {
        String accessPointName = null;
        accessPointName = RulesFunctions.listAccess(locals.accessPointArn().resourceId(), 3);
        if (accessPointName != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule37(params, locals = locals.toBuilder().accessPointName(accessPointName).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule43(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(S3ControlEndpointParams params, LocalState locals) {
        if ("accesspoint".equals(locals.outpostType())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule38(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule39(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule40(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule41(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule42(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.accessPointArn().region() + "." + locals.arnPartition().dualStackDnsSuffix())).putHeader("x-amz-account-id", locals.accessPointArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.accessPointArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule39(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.accessPointArn().region() + "." + locals.arnPartition().dnsSuffix())).putHeader("x-amz-account-id", locals.accessPointArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.accessPointArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule40(S3ControlEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.accessPointArn().region() + "." + locals.arnPartition().dualStackDnsSuffix())).putHeader("x-amz-account-id", locals.accessPointArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.accessPointArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleUrl url = null;
            url = RulesFunctions.parseURL(params.endpoint());
            if (url != null) {
                locals = locals.toBuilder().url(url).build();
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.url().authority() + locals.url().path())).putHeader("x-amz-account-id", locals.accessPointArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.accessPointArn().region()).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.accessPointArn().region() + "." + locals.arnPartition().dnsSuffix())).putHeader("x-amz-account-id", locals.accessPointArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.accessPointArn().region()).build())).build());
    }

    private static RuleResult endpointRule43(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Expected an outpost type `accesspoint`, found `" + locals.outpostType() + "`");
    }

    private static RuleResult endpointRule44(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: expected an access point name");
    }

    private static RuleResult endpointRule45(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Expected a 4-component resource");
    }

    private static RuleResult endpointRule46(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + locals.accessPointArn().accountId() + "`");
    }

    private static RuleResult endpointRule47(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: missing account ID");
    }

    private static RuleResult endpointRule48(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid region in ARN: `" + locals.accessPointArn().region() + "` (invalid DNS name)");
    }

    private static RuleResult endpointRule49(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Client was configured for partition `" + locals.partitionResult().name() + "` but ARN has `" + locals.arnPartition().name() + "`");
    }

    private static RuleResult endpointRule50(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `" + locals.outpostId() + "`");
    }

    private static RuleResult endpointRule51(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The Outpost Id was not set");
    }

    private static RuleResult endpointRule52(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: No ARN type specified");
    }

    private static RuleResult endpointRule53(S3ControlEndpointParams params, LocalState locals) {
        if (params.bucket() != null) {
            RuleArn bucketArn = null;
            bucketArn = RulesFunctions.awsParseArn(params.bucket());
            if (bucketArn != null) {
                RuleResult result = DefaultS3ControlEndpointProvider.endpointRule54(params, locals = locals.toBuilder().bucketArn(bucketArn).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultS3ControlEndpointProvider.endpointRule84(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule54(S3ControlEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.bucketArn().resourceId(), 0);
        if (arnType != null && !"".equals((locals = locals.toBuilder().arnType(arnType).build()).arnType())) {
            return DefaultS3ControlEndpointProvider.endpointRule55(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule55(S3ControlEndpointParams params, LocalState locals) {
        if ("s3-outposts".equals(locals.bucketArn().service())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule56(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule83(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule56(S3ControlEndpointParams params, LocalState locals) {
        String outpostId = null;
        outpostId = RulesFunctions.listAccess(locals.bucketArn().resourceId(), 1);
        if (outpostId != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule57(params, locals = locals.toBuilder().outpostId(outpostId).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule82(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule57(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.outpostId(), false)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule58(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule59(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule60(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule58(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null && params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule59(S3ControlEndpointParams params, LocalState locals) {
        if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(locals.bucketArn().region(), locals.region())) {
            return RuleResult.error("Invalid configuration: region from ARN `" + locals.bucketArn().region() + "` does not match client region `" + locals.region() + "` and UseArnRegion is `false`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule60(S3ControlEndpointParams params, LocalState locals) {
        RulePartition arnPartition = null;
        arnPartition = RulesFunctions.awsPartition(locals.bucketArn().region());
        if (arnPartition != null) {
            locals = locals.toBuilder().arnPartition(arnPartition).build();
            return DefaultS3ControlEndpointProvider.endpointRule61(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule61(S3ControlEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule62(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule81(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule62(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.arnPartition().name(), locals.partitionResult().name())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule63(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule80(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule63(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.bucketArn().region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule64(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule79(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule64(S3ControlEndpointParams params, LocalState locals) {
        if (!"".equals(locals.bucketArn().accountId())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule65(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule78(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule65(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.bucketArn().accountId(), false)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule66(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule67(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule77(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule66(S3ControlEndpointParams params, LocalState locals) {
        if (params.accountId() != null && !RulesFunctions.stringEquals(params.accountId(), locals.bucketArn().accountId())) {
            return RuleResult.error("Invalid ARN: the accountId specified in the ARN (`" + locals.bucketArn().accountId() + "`) does not match the parameter (`" + params.accountId() + "`)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule67(S3ControlEndpointParams params, LocalState locals) {
        String outpostType = null;
        outpostType = RulesFunctions.listAccess(locals.bucketArn().resourceId(), 2);
        if (outpostType != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule68(params, locals = locals.toBuilder().outpostType(outpostType).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule76(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule68(S3ControlEndpointParams params, LocalState locals) {
        String bucketName = null;
        bucketName = RulesFunctions.listAccess(locals.bucketArn().resourceId(), 3);
        if (bucketName != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule69(params, locals = locals.toBuilder().bucketName(bucketName).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule75(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule69(S3ControlEndpointParams params, LocalState locals) {
        if ("bucket".equals(locals.outpostType())) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule70(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule71(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule72(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule73(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule74(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule70(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.bucketArn().region() + "." + locals.arnPartition().dualStackDnsSuffix())).putHeader("x-amz-account-id", locals.bucketArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.bucketArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule71(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts-fips." + locals.bucketArn().region() + "." + locals.arnPartition().dnsSuffix())).putHeader("x-amz-account-id", locals.bucketArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.bucketArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule72(S3ControlEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.bucketArn().region() + "." + locals.arnPartition().dualStackDnsSuffix())).putHeader("x-amz-account-id", locals.bucketArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.bucketArn().region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule73(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleUrl url = null;
            url = RulesFunctions.parseURL(params.endpoint());
            if (url != null) {
                locals = locals.toBuilder().url(url).build();
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.url().authority() + locals.url().path())).putHeader("x-amz-account-id", locals.bucketArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.bucketArn().region()).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule74(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-outposts." + locals.bucketArn().region() + "." + locals.arnPartition().dnsSuffix())).putHeader("x-amz-account-id", locals.bucketArn().accountId()).putHeader("x-amz-outpost-id", locals.outpostId()).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(locals.bucketArn().region()).build())).build());
    }

    private static RuleResult endpointRule75(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Expected an outpost type `bucket`, found `" + locals.outpostType() + "`");
    }

    private static RuleResult endpointRule76(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: expected a bucket name");
    }

    private static RuleResult endpointRule77(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Expected a 4-component resource");
    }

    private static RuleResult endpointRule78(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + locals.bucketArn().accountId() + "`");
    }

    private static RuleResult endpointRule79(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: missing account ID");
    }

    private static RuleResult endpointRule80(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid region in ARN: `" + locals.bucketArn().region() + "` (invalid DNS name)");
    }

    private static RuleResult endpointRule81(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Client was configured for partition `" + locals.partitionResult().name() + "` but ARN has `" + locals.arnPartition().name() + "`");
    }

    private static RuleResult endpointRule82(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `" + locals.outpostId() + "`");
    }

    private static RuleResult endpointRule83(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The Outpost Id was not set");
    }

    private static RuleResult endpointRule84(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: No ARN type specified");
    }

    private static RuleResult endpointRule85(S3ControlEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule86(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule102(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule86(S3ControlEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.region(), true)) {
            RuleResult result = DefaultS3ControlEndpointProvider.endpointRule87(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule88(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule89(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule90(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule94(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule95(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule96(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule97(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule98(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule99(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3ControlEndpointProvider.endpointRule100(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3ControlEndpointProvider.endpointRule101(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule87(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && "aws-cn".equals(locals.partitionResult().name())) {
            return RuleResult.error("Partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule88(S3ControlEndpointParams params, LocalState locals) {
        if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() == null) {
            return RuleResult.error("AccountId is required but not set");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule89(S3ControlEndpointParams params, LocalState locals) {
        if (params.accountId() != null && !RulesFunctions.isValidHostLabel(params.accountId(), false)) {
            return RuleResult.error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule90(S3ControlEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleUrl url = null;
            url = RulesFunctions.parseURL(params.endpoint());
            if (url != null) {
                RuleResult result = DefaultS3ControlEndpointProvider.endpointRule91(params, locals = locals.toBuilder().url(url).build());
                if (result.isResolved()) {
                    return result;
                }
                result = DefaultS3ControlEndpointProvider.endpointRule92(params, locals);
                if (result.isResolved()) {
                    return result;
                }
                return DefaultS3ControlEndpointProvider.endpointRule93(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule91(S3ControlEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: DualStack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule92(S3ControlEndpointParams params, LocalState locals) {
        if (params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + params.accountId() + "." + locals.url().authority() + locals.url().path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule93(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.url().authority() + locals.url().path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
    }

    private static RuleResult endpointRule94(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control-fips.dualstack." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule95(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control-fips.dualstack." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule96(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule97(S3ControlEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule98(S3ControlEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control.dualstack." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule99(S3ControlEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control.dualstack." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule100(S3ControlEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.requiresAccountId() != null && params.requiresAccountId().booleanValue() && params.accountId() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".s3-control." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule101(S3ControlEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-control." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(locals.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule102(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid region: region was not a valid DNS name.");
    }

    private static RuleResult endpointRule103(S3ControlEndpointParams params, LocalState locals) {
        return RuleResult.error("Region must be set");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RuleUrl url;
        private RulePartition partitionResult;
        private RuleArn accessPointArn;
        private String arnType;
        private String outpostId;
        private RulePartition arnPartition;
        private String outpostType;
        private String accessPointName;
        private RuleArn bucketArn;
        private String bucketName;

        LocalStateBuilder() {
            this.region = null;
            this.url = null;
            this.partitionResult = null;
            this.accessPointArn = null;
            this.arnType = null;
            this.outpostId = null;
            this.arnPartition = null;
            this.outpostType = null;
            this.accessPointName = null;
            this.bucketArn = null;
            this.bucketName = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.url = locals.url;
            this.partitionResult = locals.partitionResult;
            this.accessPointArn = locals.accessPointArn;
            this.arnType = locals.arnType;
            this.outpostId = locals.outpostId;
            this.arnPartition = locals.arnPartition;
            this.outpostType = locals.outpostType;
            this.accessPointName = locals.accessPointName;
            this.bucketArn = locals.bucketArn;
            this.bucketName = locals.bucketName;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder url(RuleUrl value) {
            this.url = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        public LocalStateBuilder accessPointArn(RuleArn value) {
            this.accessPointArn = value;
            return this;
        }

        public LocalStateBuilder arnType(String value) {
            this.arnType = value;
            return this;
        }

        public LocalStateBuilder outpostId(String value) {
            this.outpostId = value;
            return this;
        }

        public LocalStateBuilder arnPartition(RulePartition value) {
            this.arnPartition = value;
            return this;
        }

        public LocalStateBuilder outpostType(String value) {
            this.outpostType = value;
            return this;
        }

        public LocalStateBuilder accessPointName(String value) {
            this.accessPointName = value;
            return this;
        }

        public LocalStateBuilder bucketArn(RuleArn value) {
            this.bucketArn = value;
            return this;
        }

        public LocalStateBuilder bucketName(String value) {
            this.bucketName = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RuleUrl url;
        private final RulePartition partitionResult;
        private final RuleArn accessPointArn;
        private final String arnType;
        private final String outpostId;
        private final RulePartition arnPartition;
        private final String outpostType;
        private final String accessPointName;
        private final RuleArn bucketArn;
        private final String bucketName;

        LocalState() {
            this.region = null;
            this.url = null;
            this.partitionResult = null;
            this.accessPointArn = null;
            this.arnType = null;
            this.outpostId = null;
            this.arnPartition = null;
            this.outpostType = null;
            this.accessPointName = null;
            this.bucketArn = null;
            this.bucketName = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.url = null;
            this.partitionResult = null;
            this.accessPointArn = null;
            this.arnType = null;
            this.outpostId = null;
            this.arnPartition = null;
            this.outpostType = null;
            this.accessPointName = null;
            this.bucketArn = null;
            this.bucketName = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.url = builder.url;
            this.partitionResult = builder.partitionResult;
            this.accessPointArn = builder.accessPointArn;
            this.arnType = builder.arnType;
            this.outpostId = builder.outpostId;
            this.arnPartition = builder.arnPartition;
            this.outpostType = builder.outpostType;
            this.accessPointName = builder.accessPointName;
            this.bucketArn = builder.bucketArn;
            this.bucketName = builder.bucketName;
        }

        public String region() {
            return this.region;
        }

        public RuleUrl url() {
            return this.url;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public RuleArn accessPointArn() {
            return this.accessPointArn;
        }

        public String arnType() {
            return this.arnType;
        }

        public String outpostId() {
            return this.outpostId;
        }

        public RulePartition arnPartition() {
            return this.arnPartition;
        }

        public String outpostType() {
            return this.outpostType;
        }

        public String accessPointName() {
            return this.accessPointName;
        }

        public RuleArn bucketArn() {
            return this.bucketArn;
        }

        public String bucketName() {
            return this.bucketName;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

