/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.AccessPoint;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForDirectoryBucketsResponse;

public class ListAccessPointsForDirectoryBucketsPublisher
implements SdkPublisher<ListAccessPointsForDirectoryBucketsResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessPointsForDirectoryBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPointsForDirectoryBucketsPublisher(S3ControlAsyncClient client, ListAccessPointsForDirectoryBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPointsForDirectoryBucketsPublisher(S3ControlAsyncClient client, ListAccessPointsForDirectoryBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPointsForDirectoryBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPointsForDirectoryBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessPoint> accessPointList() {
        Function<ListAccessPointsForDirectoryBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPointList() != null) {
                return response.accessPointList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessPointsForDirectoryBucketsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessPointsForDirectoryBucketsResponseFetcher
    implements AsyncPageFetcher<ListAccessPointsForDirectoryBucketsResponse> {
        private ListAccessPointsForDirectoryBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsForDirectoryBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPointsForDirectoryBucketsResponse> nextPage(ListAccessPointsForDirectoryBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsForDirectoryBucketsPublisher.this.client.listAccessPointsForDirectoryBuckets(ListAccessPointsForDirectoryBucketsPublisher.this.firstRequest);
            }
            return ListAccessPointsForDirectoryBucketsPublisher.this.client.listAccessPointsForDirectoryBuckets((ListAccessPointsForDirectoryBucketsRequest)((Object)ListAccessPointsForDirectoryBucketsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

