/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ActivityMetrics;
import software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics;
import software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics;
import software.amazon.awssdk.services.s3control.model.BucketLevel;
import software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics;
import software.amazon.awssdk.services.s3control.model.StorageLensGroupLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLevel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActivityMetrics").getter(AccountLevel.getter(AccountLevel::activityMetrics)).setter(AccountLevel.setter(Builder::activityMetrics)).constructor(ActivityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics").unmarshallLocationName("ActivityMetrics").build()}).build();
    private static final SdkField<BucketLevel> BUCKET_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketLevel").getter(AccountLevel.getter(AccountLevel::bucketLevel)).setter(AccountLevel.setter(Builder::bucketLevel)).constructor(BucketLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLevel").unmarshallLocationName("BucketLevel").build()}).build();
    private static final SdkField<AdvancedCostOptimizationMetrics> ADVANCED_COST_OPTIMIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedCostOptimizationMetrics").getter(AccountLevel.getter(AccountLevel::advancedCostOptimizationMetrics)).setter(AccountLevel.setter(Builder::advancedCostOptimizationMetrics)).constructor(AdvancedCostOptimizationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedCostOptimizationMetrics").unmarshallLocationName("AdvancedCostOptimizationMetrics").build()}).build();
    private static final SdkField<AdvancedDataProtectionMetrics> ADVANCED_DATA_PROTECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedDataProtectionMetrics").getter(AccountLevel.getter(AccountLevel::advancedDataProtectionMetrics)).setter(AccountLevel.setter(Builder::advancedDataProtectionMetrics)).constructor(AdvancedDataProtectionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedDataProtectionMetrics").unmarshallLocationName("AdvancedDataProtectionMetrics").build()}).build();
    private static final SdkField<DetailedStatusCodesMetrics> DETAILED_STATUS_CODES_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetailedStatusCodesMetrics").getter(AccountLevel.getter(AccountLevel::detailedStatusCodesMetrics)).setter(AccountLevel.setter(Builder::detailedStatusCodesMetrics)).constructor(DetailedStatusCodesMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatusCodesMetrics").unmarshallLocationName("DetailedStatusCodesMetrics").build()}).build();
    private static final SdkField<StorageLensGroupLevel> STORAGE_LENS_GROUP_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLensGroupLevel").getter(AccountLevel.getter(AccountLevel::storageLensGroupLevel)).setter(AccountLevel.setter(Builder::storageLensGroupLevel)).constructor(StorageLensGroupLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroupLevel").unmarshallLocationName("StorageLensGroupLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD, BUCKET_LEVEL_FIELD, ADVANCED_COST_OPTIMIZATION_METRICS_FIELD, ADVANCED_DATA_PROTECTION_METRICS_FIELD, DETAILED_STATUS_CODES_METRICS_FIELD, STORAGE_LENS_GROUP_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountLevel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ActivityMetrics activityMetrics;
    private final BucketLevel bucketLevel;
    private final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;
    private final AdvancedDataProtectionMetrics advancedDataProtectionMetrics;
    private final DetailedStatusCodesMetrics detailedStatusCodesMetrics;
    private final StorageLensGroupLevel storageLensGroupLevel;

    private AccountLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.bucketLevel = builder.bucketLevel;
        this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
        this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
        this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
        this.storageLensGroupLevel = builder.storageLensGroupLevel;
    }

    public final ActivityMetrics activityMetrics() {
        return this.activityMetrics;
    }

    public final BucketLevel bucketLevel() {
        return this.bucketLevel;
    }

    public final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics() {
        return this.advancedCostOptimizationMetrics;
    }

    public final AdvancedDataProtectionMetrics advancedDataProtectionMetrics() {
        return this.advancedDataProtectionMetrics;
    }

    public final DetailedStatusCodesMetrics detailedStatusCodesMetrics() {
        return this.detailedStatusCodesMetrics;
    }

    public final StorageLensGroupLevel storageLensGroupLevel() {
        return this.storageLensGroupLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedCostOptimizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedDataProtectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatusCodesMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensGroupLevel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevel)) {
            return false;
        }
        AccountLevel other = (AccountLevel)obj;
        return Objects.equals(this.activityMetrics(), other.activityMetrics()) && Objects.equals(this.bucketLevel(), other.bucketLevel()) && Objects.equals(this.advancedCostOptimizationMetrics(), other.advancedCostOptimizationMetrics()) && Objects.equals(this.advancedDataProtectionMetrics(), other.advancedDataProtectionMetrics()) && Objects.equals(this.detailedStatusCodesMetrics(), other.detailedStatusCodesMetrics()) && Objects.equals(this.storageLensGroupLevel(), other.storageLensGroupLevel());
    }

    public final String toString() {
        return ToString.builder((String)"AccountLevel").add("ActivityMetrics", (Object)this.activityMetrics()).add("BucketLevel", (Object)this.bucketLevel()).add("AdvancedCostOptimizationMetrics", (Object)this.advancedCostOptimizationMetrics()).add("AdvancedDataProtectionMetrics", (Object)this.advancedDataProtectionMetrics()).add("DetailedStatusCodesMetrics", (Object)this.detailedStatusCodesMetrics()).add("StorageLensGroupLevel", (Object)this.storageLensGroupLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityMetrics": {
                return Optional.ofNullable(clazz.cast(this.activityMetrics()));
            }
            case "BucketLevel": {
                return Optional.ofNullable(clazz.cast(this.bucketLevel()));
            }
            case "AdvancedCostOptimizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.advancedCostOptimizationMetrics()));
            }
            case "AdvancedDataProtectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.advancedDataProtectionMetrics()));
            }
            case "DetailedStatusCodesMetrics": {
                return Optional.ofNullable(clazz.cast(this.detailedStatusCodesMetrics()));
            }
            case "StorageLensGroupLevel": {
                return Optional.ofNullable(clazz.cast(this.storageLensGroupLevel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActivityMetrics", ACTIVITY_METRICS_FIELD);
        map.put("BucketLevel", BUCKET_LEVEL_FIELD);
        map.put("AdvancedCostOptimizationMetrics", ADVANCED_COST_OPTIMIZATION_METRICS_FIELD);
        map.put("AdvancedDataProtectionMetrics", ADVANCED_DATA_PROTECTION_METRICS_FIELD);
        map.put("DetailedStatusCodesMetrics", DETAILED_STATUS_CODES_METRICS_FIELD);
        map.put("StorageLensGroupLevel", STORAGE_LENS_GROUP_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountLevel, T> g) {
        return obj -> g.apply((AccountLevel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityMetrics activityMetrics;
        private BucketLevel bucketLevel;
        private AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;
        private AdvancedDataProtectionMetrics advancedDataProtectionMetrics;
        private DetailedStatusCodesMetrics detailedStatusCodesMetrics;
        private StorageLensGroupLevel storageLensGroupLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevel model) {
            this.activityMetrics(model.activityMetrics);
            this.bucketLevel(model.bucketLevel);
            this.advancedCostOptimizationMetrics(model.advancedCostOptimizationMetrics);
            this.advancedDataProtectionMetrics(model.advancedDataProtectionMetrics);
            this.detailedStatusCodesMetrics(model.detailedStatusCodesMetrics);
            this.storageLensGroupLevel(model.storageLensGroupLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return this.activityMetrics != null ? this.activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final BucketLevel.Builder getBucketLevel() {
            return this.bucketLevel != null ? this.bucketLevel.toBuilder() : null;
        }

        public final void setBucketLevel(BucketLevel.BuilderImpl bucketLevel) {
            this.bucketLevel = bucketLevel != null ? bucketLevel.build() : null;
        }

        @Override
        public final Builder bucketLevel(BucketLevel bucketLevel) {
            this.bucketLevel = bucketLevel;
            return this;
        }

        public final AdvancedCostOptimizationMetrics.Builder getAdvancedCostOptimizationMetrics() {
            return this.advancedCostOptimizationMetrics != null ? this.advancedCostOptimizationMetrics.toBuilder() : null;
        }

        public final void setAdvancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics.BuilderImpl advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics.build() : null;
        }

        @Override
        public final Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
            return this;
        }

        public final AdvancedDataProtectionMetrics.Builder getAdvancedDataProtectionMetrics() {
            return this.advancedDataProtectionMetrics != null ? this.advancedDataProtectionMetrics.toBuilder() : null;
        }

        public final void setAdvancedDataProtectionMetrics(AdvancedDataProtectionMetrics.BuilderImpl advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.build() : null;
        }

        @Override
        public final Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
            return this;
        }

        public final DetailedStatusCodesMetrics.Builder getDetailedStatusCodesMetrics() {
            return this.detailedStatusCodesMetrics != null ? this.detailedStatusCodesMetrics.toBuilder() : null;
        }

        public final void setDetailedStatusCodesMetrics(DetailedStatusCodesMetrics.BuilderImpl detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.build() : null;
        }

        @Override
        public final Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
            return this;
        }

        public final StorageLensGroupLevel.Builder getStorageLensGroupLevel() {
            return this.storageLensGroupLevel != null ? this.storageLensGroupLevel.toBuilder() : null;
        }

        public final void setStorageLensGroupLevel(StorageLensGroupLevel.BuilderImpl storageLensGroupLevel) {
            this.storageLensGroupLevel = storageLensGroupLevel != null ? storageLensGroupLevel.build() : null;
        }

        @Override
        public final Builder storageLensGroupLevel(StorageLensGroupLevel storageLensGroupLevel) {
            this.storageLensGroupLevel = storageLensGroupLevel;
            return this;
        }

        public AccountLevel build() {
            return new AccountLevel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountLevel> {
        public Builder activityMetrics(ActivityMetrics var1);

        default public Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return this.activityMetrics((ActivityMetrics)((ActivityMetrics.Builder)ActivityMetrics.builder().applyMutation(activityMetrics)).build());
        }

        public Builder bucketLevel(BucketLevel var1);

        default public Builder bucketLevel(Consumer<BucketLevel.Builder> bucketLevel) {
            return this.bucketLevel((BucketLevel)((BucketLevel.Builder)BucketLevel.builder().applyMutation(bucketLevel)).build());
        }

        public Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics var1);

        default public Builder advancedCostOptimizationMetrics(Consumer<AdvancedCostOptimizationMetrics.Builder> advancedCostOptimizationMetrics) {
            return this.advancedCostOptimizationMetrics((AdvancedCostOptimizationMetrics)((AdvancedCostOptimizationMetrics.Builder)AdvancedCostOptimizationMetrics.builder().applyMutation(advancedCostOptimizationMetrics)).build());
        }

        public Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics var1);

        default public Builder advancedDataProtectionMetrics(Consumer<AdvancedDataProtectionMetrics.Builder> advancedDataProtectionMetrics) {
            return this.advancedDataProtectionMetrics((AdvancedDataProtectionMetrics)((AdvancedDataProtectionMetrics.Builder)AdvancedDataProtectionMetrics.builder().applyMutation(advancedDataProtectionMetrics)).build());
        }

        public Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics var1);

        default public Builder detailedStatusCodesMetrics(Consumer<DetailedStatusCodesMetrics.Builder> detailedStatusCodesMetrics) {
            return this.detailedStatusCodesMetrics((DetailedStatusCodesMetrics)((DetailedStatusCodesMetrics.Builder)DetailedStatusCodesMetrics.builder().applyMutation(detailedStatusCodesMetrics)).build());
        }

        public Builder storageLensGroupLevel(StorageLensGroupLevel var1);

        default public Builder storageLensGroupLevel(Consumer<StorageLensGroupLevel.Builder> storageLensGroupLevel) {
            return this.storageLensGroupLevel((StorageLensGroupLevel)((StorageLensGroupLevel.Builder)StorageLensGroupLevel.builder().applyMutation(storageLensGroupLevel)).build());
        }
    }
}

