/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.VersioningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBucketVersioningRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, PutBucketVersioningRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutBucketVersioningRequest.getter(PutBucketVersioningRequest::accountId)).setter(PutBucketVersioningRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(PutBucketVersioningRequest.getter(PutBucketVersioningRequest::bucket)).setter(PutBucketVersioningRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> MFA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MFA").getter(PutBucketVersioningRequest.getter(PutBucketVersioningRequest::mfa)).setter(PutBucketVersioningRequest.setter(Builder::mfa)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mfa").unmarshallLocationName("x-amz-mfa").build()}).build();
    private static final SdkField<VersioningConfiguration> VERSIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VersioningConfiguration").getter(PutBucketVersioningRequest.getter(PutBucketVersioningRequest::versioningConfiguration)).setter(PutBucketVersioningRequest.setter(Builder::versioningConfiguration)).constructor(VersioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersioningConfiguration").unmarshallLocationName("VersioningConfiguration").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUCKET_FIELD, MFA_FIELD, VERSIONING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutBucketVersioningRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String bucket;
    private final String mfa;
    private final VersioningConfiguration versioningConfiguration;

    private PutBucketVersioningRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.mfa = builder.mfa;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String mfa() {
        return this.mfa;
    }

    public final VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfa());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioningConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketVersioningRequest)) {
            return false;
        }
        PutBucketVersioningRequest other = (PutBucketVersioningRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.mfa(), other.mfa()) && Objects.equals(this.versioningConfiguration(), other.versioningConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutBucketVersioningRequest").add("AccountId", (Object)this.accountId()).add("Bucket", (Object)this.bucket()).add("MFA", (Object)this.mfa()).add("VersioningConfiguration", (Object)this.versioningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "MFA": {
                return Optional.ofNullable(clazz.cast(this.mfa()));
            }
            case "VersioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.versioningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("name", BUCKET_FIELD);
        map.put("x-amz-mfa", MFA_FIELD);
        map.put("VersioningConfiguration", VERSIONING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutBucketVersioningRequest, T> g) {
        return obj -> g.apply((PutBucketVersioningRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String bucket;
        private String mfa;
        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketVersioningRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.bucket(model.bucket);
            this.mfa(model.mfa);
            this.versioningConfiguration(model.versioningConfiguration);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getMfa() {
            return this.mfa;
        }

        public final void setMfa(String mfa) {
            this.mfa = mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return this.versioningConfiguration != null ? this.versioningConfiguration.toBuilder() : null;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketVersioningRequest build() {
            return new PutBucketVersioningRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBucketVersioningRequest> {
        public Builder accountId(String var1);

        public Builder bucket(String var1);

        public Builder mfa(String var1);

        public Builder versioningConfiguration(VersioningConfiguration var1);

        default public Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return this.versioningConfiguration((VersioningConfiguration)((VersioningConfiguration.Builder)VersioningConfiguration.builder().applyMutation(versioningConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

