/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsResponse;

public class ListAccessGrantsLocationsIterable
implements SdkIterable<ListAccessGrantsLocationsResponse> {
    private final S3ControlClient client;
    private final ListAccessGrantsLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessGrantsLocationsIterable(S3ControlClient client, ListAccessGrantsLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessGrantsLocationsResponseFetcher();
    }

    public Iterator<ListAccessGrantsLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessGrantsLocationsResponseFetcher
    implements SyncPageFetcher<ListAccessGrantsLocationsResponse> {
        private ListAccessGrantsLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessGrantsLocationsResponse nextPage(ListAccessGrantsLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsLocationsIterable.this.client.listAccessGrantsLocations(ListAccessGrantsLocationsIterable.this.firstRequest);
            }
            return ListAccessGrantsLocationsIterable.this.client.listAccessGrantsLocations((ListAccessGrantsLocationsRequest)((Object)ListAccessGrantsLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

