/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.StorageLensGroupFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageLensGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageLensGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StorageLensGroup.getter(StorageLensGroup::name)).setter(StorageLensGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<StorageLensGroupFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(StorageLensGroup.getter(StorageLensGroup::filter)).setter(StorageLensGroup.setter(Builder::filter)).constructor(StorageLensGroupFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build();
    private static final SdkField<String> STORAGE_LENS_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageLensGroupArn").getter(StorageLensGroup.getter(StorageLensGroup::storageLensGroupArn)).setter(StorageLensGroup.setter(Builder::storageLensGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroupArn").unmarshallLocationName("StorageLensGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTER_FIELD, STORAGE_LENS_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Filter", FILTER_FIELD);
            this.put("StorageLensGroupArn", STORAGE_LENS_GROUP_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final StorageLensGroupFilter filter;
    private final String storageLensGroupArn;

    private StorageLensGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.filter = builder.filter;
        this.storageLensGroupArn = builder.storageLensGroupArn;
    }

    public final String name() {
        return this.name;
    }

    public final StorageLensGroupFilter filter() {
        return this.filter;
    }

    public final String storageLensGroupArn() {
        return this.storageLensGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroup)) {
            return false;
        }
        StorageLensGroup other = (StorageLensGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.storageLensGroupArn(), other.storageLensGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"StorageLensGroup").add("Name", (Object)this.name()).add("Filter", (Object)this.filter()).add("StorageLensGroupArn", (Object)this.storageLensGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "StorageLensGroupArn": {
                return Optional.ofNullable(clazz.cast(this.storageLensGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroup, T> g) {
        return obj -> g.apply((StorageLensGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private StorageLensGroupFilter filter;
        private String storageLensGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroup model) {
            this.name(model.name);
            this.filter(model.filter);
            this.storageLensGroupArn(model.storageLensGroupArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StorageLensGroupFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(StorageLensGroupFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(StorageLensGroupFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getStorageLensGroupArn() {
            return this.storageLensGroupArn;
        }

        public final void setStorageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
        }

        @Override
        public final Builder storageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
            return this;
        }

        public StorageLensGroup build() {
            return new StorageLensGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageLensGroup> {
        public Builder name(String var1);

        public Builder filter(StorageLensGroupFilter var1);

        default public Builder filter(Consumer<StorageLensGroupFilter.Builder> filter) {
            return this.filter((StorageLensGroupFilter)((StorageLensGroupFilter.Builder)StorageLensGroupFilter.builder().applyMutation(filter)).build());
        }

        public Builder storageLensGroupArn(String var1);
    }
}

