/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.Credentials;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataAccessResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetDataAccessResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(GetDataAccessResponse.getter(GetDataAccessResponse::credentials)).setter(GetDataAccessResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").unmarshallLocationName("Credentials").build()}).build();
    private static final SdkField<String> MATCHED_GRANT_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchedGrantTarget").getter(GetDataAccessResponse.getter(GetDataAccessResponse::matchedGrantTarget)).setter(GetDataAccessResponse.setter(Builder::matchedGrantTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedGrantTarget").unmarshallLocationName("MatchedGrantTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, MATCHED_GRANT_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("MatchedGrantTarget", MATCHED_GRANT_TARGET_FIELD);
        }
    });
    private final Credentials credentials;
    private final String matchedGrantTarget;

    private GetDataAccessResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.matchedGrantTarget = builder.matchedGrantTarget;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final String matchedGrantTarget() {
        return this.matchedGrantTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedGrantTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessResponse)) {
            return false;
        }
        GetDataAccessResponse other = (GetDataAccessResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.matchedGrantTarget(), other.matchedGrantTarget());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataAccessResponse").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("MatchedGrantTarget", (Object)this.matchedGrantTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "MatchedGrantTarget": {
                return Optional.ofNullable(clazz.cast(this.matchedGrantTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessResponse, T> g) {
        return obj -> g.apply((GetDataAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String matchedGrantTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.matchedGrantTarget(model.matchedGrantTarget);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getMatchedGrantTarget() {
            return this.matchedGrantTarget;
        }

        public final void setMatchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
        }

        @Override
        public final Builder matchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
            return this;
        }

        @Override
        public GetDataAccessResponse build() {
            return new GetDataAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataAccessResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder matchedGrantTarget(String var1);
    }
}

