/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccessGrantsInstanceResourcePolicyRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, PutAccessGrantsInstanceResourcePolicyRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutAccessGrantsInstanceResourcePolicyRequest.getter(PutAccessGrantsInstanceResourcePolicyRequest::accountId)).setter(PutAccessGrantsInstanceResourcePolicyRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(PutAccessGrantsInstanceResourcePolicyRequest.getter(PutAccessGrantsInstanceResourcePolicyRequest::policy)).setter(PutAccessGrantsInstanceResourcePolicyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").unmarshallLocationName("Policy").build()}).build();
    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Organization").getter(PutAccessGrantsInstanceResourcePolicyRequest.getter(PutAccessGrantsInstanceResourcePolicyRequest::organization)).setter(PutAccessGrantsInstanceResourcePolicyRequest.setter(Builder::organization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").unmarshallLocationName("Organization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, POLICY_FIELD, ORGANIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-account-id", ACCOUNT_ID_FIELD);
            this.put("Policy", POLICY_FIELD);
            this.put("Organization", ORGANIZATION_FIELD);
        }
    });
    private final String accountId;
    private final String policy;
    private final String organization;

    private PutAccessGrantsInstanceResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.policy = builder.policy;
        this.organization = builder.organization;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String policy() {
        return this.policy;
    }

    public final String organization() {
        return this.organization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccessGrantsInstanceResourcePolicyRequest)) {
            return false;
        }
        PutAccessGrantsInstanceResourcePolicyRequest other = (PutAccessGrantsInstanceResourcePolicyRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.organization(), other.organization());
    }

    public final String toString() {
        return ToString.builder((String)"PutAccessGrantsInstanceResourcePolicyRequest").add("AccountId", (Object)this.accountId()).add("Policy", (Object)this.policy()).add("Organization", (Object)this.organization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutAccessGrantsInstanceResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutAccessGrantsInstanceResourcePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String policy;
        private String organization;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccessGrantsInstanceResourcePolicyRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.policy(model.policy);
            this.organization(model.organization);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getOrganization() {
            return this.organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccessGrantsInstanceResourcePolicyRequest build() {
            return new PutAccessGrantsInstanceResourcePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccessGrantsInstanceResourcePolicyRequest> {
        public Builder accountId(String var1);

        public Builder policy(String var1);

        public Builder organization(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

