/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.AccessGrantsLocationConfiguration;
import software.amazon.awssdk.services.s3control.model.Grantee;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessGrantResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, CreateAccessGrantResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::createdAt)).setter(CreateAccessGrantResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("CreatedAt").build()}).build();
    private static final SdkField<String> ACCESS_GRANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantId").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::accessGrantId)).setter(CreateAccessGrantResponse.setter(Builder::accessGrantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantId").unmarshallLocationName("AccessGrantId").build()}).build();
    private static final SdkField<String> ACCESS_GRANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantArn").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::accessGrantArn)).setter(CreateAccessGrantResponse.setter(Builder::accessGrantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantArn").unmarshallLocationName("AccessGrantArn").build()}).build();
    private static final SdkField<Grantee> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Grantee").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::grantee)).setter(CreateAccessGrantResponse.setter(Builder::grantee)).constructor(Grantee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").unmarshallLocationName("Grantee").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsLocationId").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::accessGrantsLocationId)).setter(CreateAccessGrantResponse.setter(Builder::accessGrantsLocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationId").unmarshallLocationName("AccessGrantsLocationId").build()}).build();
    private static final SdkField<AccessGrantsLocationConfiguration> ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessGrantsLocationConfiguration").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::accessGrantsLocationConfiguration)).setter(CreateAccessGrantResponse.setter(Builder::accessGrantsLocationConfiguration)).constructor(AccessGrantsLocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationConfiguration").unmarshallLocationName("AccessGrantsLocationConfiguration").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::permissionAsString)).setter(CreateAccessGrantResponse.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::applicationArn)).setter(CreateAccessGrantResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").unmarshallLocationName("ApplicationArn").build()}).build();
    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantScope").getter(CreateAccessGrantResponse.getter(CreateAccessGrantResponse::grantScope)).setter(CreateAccessGrantResponse.setter(Builder::grantScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantScope").unmarshallLocationName("GrantScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ACCESS_GRANT_ID_FIELD, ACCESS_GRANT_ARN_FIELD, GRANTEE_FIELD, ACCESS_GRANTS_LOCATION_ID_FIELD, ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD, PERMISSION_FIELD, APPLICATION_ARN_FIELD, GRANT_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("AccessGrantId", ACCESS_GRANT_ID_FIELD);
            this.put("AccessGrantArn", ACCESS_GRANT_ARN_FIELD);
            this.put("Grantee", GRANTEE_FIELD);
            this.put("AccessGrantsLocationId", ACCESS_GRANTS_LOCATION_ID_FIELD);
            this.put("AccessGrantsLocationConfiguration", ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD);
            this.put("Permission", PERMISSION_FIELD);
            this.put("ApplicationArn", APPLICATION_ARN_FIELD);
            this.put("GrantScope", GRANT_SCOPE_FIELD);
        }
    });
    private final Instant createdAt;
    private final String accessGrantId;
    private final String accessGrantArn;
    private final Grantee grantee;
    private final String accessGrantsLocationId;
    private final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;
    private final String permission;
    private final String applicationArn;
    private final String grantScope;

    private CreateAccessGrantResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.accessGrantId = builder.accessGrantId;
        this.accessGrantArn = builder.accessGrantArn;
        this.grantee = builder.grantee;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.accessGrantsLocationConfiguration = builder.accessGrantsLocationConfiguration;
        this.permission = builder.permission;
        this.applicationArn = builder.applicationArn;
        this.grantScope = builder.grantScope;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String accessGrantId() {
        return this.accessGrantId;
    }

    public final String accessGrantArn() {
        return this.accessGrantArn;
    }

    public final Grantee grantee() {
        return this.grantee;
    }

    public final String accessGrantsLocationId() {
        return this.accessGrantsLocationId;
    }

    public final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration() {
        return this.accessGrantsLocationConfiguration;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String grantScope() {
        return this.grantScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantResponse)) {
            return false;
        }
        CreateAccessGrantResponse other = (CreateAccessGrantResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.accessGrantId(), other.accessGrantId()) && Objects.equals(this.accessGrantArn(), other.accessGrantArn()) && Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.accessGrantsLocationId(), other.accessGrantsLocationId()) && Objects.equals(this.accessGrantsLocationConfiguration(), other.accessGrantsLocationConfiguration()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.grantScope(), other.grantScope());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessGrantResponse").add("CreatedAt", (Object)this.createdAt()).add("AccessGrantId", (Object)this.accessGrantId()).add("AccessGrantArn", (Object)this.accessGrantArn()).add("Grantee", (Object)this.grantee()).add("AccessGrantsLocationId", (Object)this.accessGrantsLocationId()).add("AccessGrantsLocationConfiguration", (Object)this.accessGrantsLocationConfiguration()).add("Permission", (Object)this.permissionAsString()).add("ApplicationArn", (Object)this.applicationArn()).add("GrantScope", (Object)this.grantScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "AccessGrantId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantId()));
            }
            case "AccessGrantArn": {
                return Optional.ofNullable(clazz.cast(this.accessGrantArn()));
            }
            case "Grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "AccessGrantsLocationId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationId()));
            }
            case "AccessGrantsLocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationConfiguration()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "GrantScope": {
                return Optional.ofNullable(clazz.cast(this.grantScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantResponse, T> g) {
        return obj -> g.apply((CreateAccessGrantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String accessGrantId;
        private String accessGrantArn;
        private Grantee grantee;
        private String accessGrantsLocationId;
        private AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;
        private String permission;
        private String applicationArn;
        private String grantScope;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.accessGrantId(model.accessGrantId);
            this.accessGrantArn(model.accessGrantArn);
            this.grantee(model.grantee);
            this.accessGrantsLocationId(model.accessGrantsLocationId);
            this.accessGrantsLocationConfiguration(model.accessGrantsLocationConfiguration);
            this.permission(model.permission);
            this.applicationArn(model.applicationArn);
            this.grantScope(model.grantScope);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantId() {
            return this.accessGrantId;
        }

        public final void setAccessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
        }

        @Override
        public final Builder accessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
            return this;
        }

        public final String getAccessGrantArn() {
            return this.accessGrantArn;
        }

        public final void setAccessGrantArn(String accessGrantArn) {
            this.accessGrantArn = accessGrantArn;
        }

        @Override
        public final Builder accessGrantArn(String accessGrantArn) {
            this.accessGrantArn = accessGrantArn;
            return this;
        }

        public final Grantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final AccessGrantsLocationConfiguration.Builder getAccessGrantsLocationConfiguration() {
            return this.accessGrantsLocationConfiguration != null ? this.accessGrantsLocationConfiguration.toBuilder() : null;
        }

        public final void setAccessGrantsLocationConfiguration(AccessGrantsLocationConfiguration.BuilderImpl accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration != null ? accessGrantsLocationConfiguration.build() : null;
        }

        @Override
        public final Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getGrantScope() {
            return this.grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        @Override
        public CreateAccessGrantResponse build() {
            return new CreateAccessGrantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessGrantResponse> {
        public Builder createdAt(Instant var1);

        public Builder accessGrantId(String var1);

        public Builder accessGrantArn(String var1);

        public Builder grantee(Grantee var1);

        default public Builder grantee(Consumer<Grantee.Builder> grantee) {
            return this.grantee((Grantee)((Grantee.Builder)Grantee.builder().applyMutation(grantee)).build());
        }

        public Builder accessGrantsLocationId(String var1);

        public Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration var1);

        default public Builder accessGrantsLocationConfiguration(Consumer<AccessGrantsLocationConfiguration.Builder> accessGrantsLocationConfiguration) {
            return this.accessGrantsLocationConfiguration((AccessGrantsLocationConfiguration)((AccessGrantsLocationConfiguration.Builder)AccessGrantsLocationConfiguration.builder().applyMutation(accessGrantsLocationConfiguration)).build());
        }

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder applicationArn(String var1);

        public Builder grantScope(String var1);
    }
}

