/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.services.s3control.model.Privilege;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.S3PrefixType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataAccessRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, GetDataAccessRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetDataAccessRequest.getter(GetDataAccessRequest::accountId)).setter(GetDataAccessRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(GetDataAccessRequest.getter(GetDataAccessRequest::target)).setter(GetDataAccessRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("target").unmarshallLocationName("target").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(GetDataAccessRequest.getter(GetDataAccessRequest::permissionAsString)).setter(GetDataAccessRequest.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("permission").unmarshallLocationName("permission").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(GetDataAccessRequest.getter(GetDataAccessRequest::durationSeconds)).setter(GetDataAccessRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("durationSeconds").unmarshallLocationName("durationSeconds").build()}).build();
    private static final SdkField<String> PRIVILEGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Privilege").getter(GetDataAccessRequest.getter(GetDataAccessRequest::privilegeAsString)).setter(GetDataAccessRequest.setter(Builder::privilege)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("privilege").unmarshallLocationName("privilege").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(GetDataAccessRequest.getter(GetDataAccessRequest::targetTypeAsString)).setter(GetDataAccessRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetType").unmarshallLocationName("targetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, TARGET_FIELD, PERMISSION_FIELD, DURATION_SECONDS_FIELD, PRIVILEGE_FIELD, TARGET_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-account-id", ACCOUNT_ID_FIELD);
            this.put("target", TARGET_FIELD);
            this.put("permission", PERMISSION_FIELD);
            this.put("durationSeconds", DURATION_SECONDS_FIELD);
            this.put("privilege", PRIVILEGE_FIELD);
            this.put("targetType", TARGET_TYPE_FIELD);
        }
    });
    private final String accountId;
    private final String target;
    private final String permission;
    private final Integer durationSeconds;
    private final String privilege;
    private final String targetType;

    private GetDataAccessRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.target = builder.target;
        this.permission = builder.permission;
        this.durationSeconds = builder.durationSeconds;
        this.privilege = builder.privilege;
        this.targetType = builder.targetType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String target() {
        return this.target;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final Privilege privilege() {
        return Privilege.fromValue(this.privilege);
    }

    public final String privilegeAsString() {
        return this.privilege;
    }

    public final S3PrefixType targetType() {
        return S3PrefixType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessRequest)) {
            return false;
        }
        GetDataAccessRequest other = (GetDataAccessRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.privilegeAsString(), other.privilegeAsString()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataAccessRequest").add("AccountId", (Object)this.accountId()).add("Target", (Object)this.target()).add("Permission", (Object)this.permissionAsString()).add("DurationSeconds", (Object)this.durationSeconds()).add("Privilege", (Object)this.privilegeAsString()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "Privilege": {
                return Optional.ofNullable(clazz.cast(this.privilegeAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessRequest, T> g) {
        return obj -> g.apply((GetDataAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String target;
        private String permission;
        private Integer durationSeconds;
        private String privilege;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.target(model.target);
            this.permission(model.permission);
            this.durationSeconds(model.durationSeconds);
            this.privilege(model.privilege);
            this.targetType(model.targetType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getPrivilege() {
            return this.privilege;
        }

        public final void setPrivilege(String privilege) {
            this.privilege = privilege;
        }

        @Override
        public final Builder privilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        @Override
        public final Builder privilege(Privilege privilege) {
            this.privilege(privilege == null ? null : privilege.toString());
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(S3PrefixType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataAccessRequest build() {
            return new GetDataAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataAccessRequest> {
        public Builder accountId(String var1);

        public Builder target(String var1);

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder durationSeconds(Integer var1);

        public Builder privilege(String var1);

        public Builder privilege(Privilege var1);

        public Builder targetType(String var1);

        public Builder targetType(S3PrefixType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

