/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsResponse;

public class ListCallerAccessGrantsIterable
implements SdkIterable<ListCallerAccessGrantsResponse> {
    private final S3ControlClient client;
    private final ListCallerAccessGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCallerAccessGrantsIterable(S3ControlClient client, ListCallerAccessGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCallerAccessGrantsResponseFetcher();
    }

    public Iterator<ListCallerAccessGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListCallerAccessGrantsEntry> callerAccessGrantsList() {
        Function<ListCallerAccessGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.callerAccessGrantsList() != null) {
                return response.callerAccessGrantsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCallerAccessGrantsResponseFetcher
    implements SyncPageFetcher<ListCallerAccessGrantsResponse> {
        private ListCallerAccessGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListCallerAccessGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCallerAccessGrantsResponse nextPage(ListCallerAccessGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListCallerAccessGrantsIterable.this.client.listCallerAccessGrants(ListCallerAccessGrantsIterable.this.firstRequest);
            }
            return ListCallerAccessGrantsIterable.this.client.listCallerAccessGrants((ListCallerAccessGrantsRequest)((Object)ListCallerAccessGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

