/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3MetadataDirective {
    COPY("COPY"),
    REPLACE("REPLACE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3MetadataDirective> VALUE_MAP;
    private final String value;

    private S3MetadataDirective(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3MetadataDirective fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3MetadataDirective> knownValues() {
        EnumSet<S3MetadataDirective> knownValues = EnumSet.allOf(S3MetadataDirective.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3MetadataDirective.class, S3MetadataDirective::toString);
    }
}

