/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.S3Grant;

final class S3GrantListCopier {
    S3GrantListCopier() {
    }

    static List<S3Grant> copy(Collection<? extends S3Grant> s3GrantListParam) {
        Object list;
        if (s3GrantListParam == null || s3GrantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3GrantListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Grant> copyFromBuilder(Collection<? extends S3Grant.Builder> s3GrantListParam) {
        Object list;
        if (s3GrantListParam == null || s3GrantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3GrantListParam.forEach(entry -> {
                S3Grant member = entry == null ? null : (S3Grant)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Grant.Builder> copyToBuilder(Collection<? extends S3Grant> s3GrantListParam) {
        Object list;
        if (s3GrantListParam == null || s3GrantListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3GrantListParam.forEach(entry -> {
                S3Grant.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

